/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.tasks;

import com.android.builder.tasks.BooleanLatch;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.Task;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class Job<T> {
    private final String mJobTitle;
    private final Task<T> mTask;
    private final BooleanLatch mBooleanLatch;
    private final AtomicBoolean mResult = new AtomicBoolean(false);

    public Job(String jobTile, Task<T> task) {
        this.mJobTitle = jobTile;
        this.mTask = task;
        this.mBooleanLatch = new BooleanLatch();
    }

    public String getJobTitle() {
        return this.mJobTitle;
    }

    public void runTask(JobContext<T> jobContext) throws IOException {
        this.mTask.run(this, jobContext);
    }

    public void finished() {
        this.mResult.set(true);
        this.mBooleanLatch.signal();
    }

    public void error() {
        this.mResult.set(false);
        this.mBooleanLatch.signal();
    }

    public boolean await() throws InterruptedException {
        this.mBooleanLatch.await();
        return this.mResult.get();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("title", (Object)this.mJobTitle).add("task", this.mTask).add("latch", (Object)this.mBooleanLatch).add("result", this.mResult.get()).toString();
    }
}

