/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.sdk;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class DefaultSdkLoader
implements SdkLoader {
    private static DefaultSdkLoader sLoader;
    @NonNull
    private final File mSdkLocation;
    private SdkManager mSdkManager;
    private SdkInfo mSdkInfo;
    private final ImmutableList<File> mRepositories;

    public static synchronized SdkLoader getLoader(@NonNull File sdkLocation) {
        if (sLoader == null) {
            sLoader = new DefaultSdkLoader(sdkLocation);
        } else if (!sdkLocation.equals(DefaultSdkLoader.sLoader.mSdkLocation)) {
            throw new IllegalStateException("Already created an SDK Loader with different SDK Path");
        }
        return sLoader;
    }

    public static synchronized void unload() {
        sLoader = null;
    }

    @Override
    @NonNull
    public TargetInfo getTargetInfo(@NonNull String targetHash, @NonNull FullRevision buildToolRevision, @NonNull ILogger logger) {
        this.init(logger);
        IAndroidTarget target = this.mSdkManager.getTargetFromHashString(targetHash);
        if (target == null) {
            throw new IllegalStateException("failed to find target " + targetHash + " : " + this.mSdkLocation);
        }
        BuildToolInfo buildToolInfo = this.mSdkManager.getBuildTool(buildToolRevision);
        if (buildToolInfo == null) {
            throw new IllegalStateException("failed to find Build Tools revision " + buildToolRevision.toString());
        }
        return new TargetInfo(target, buildToolInfo);
    }

    @Override
    @NonNull
    public SdkInfo getSdkInfo(@NonNull ILogger logger) {
        this.init(logger);
        return this.mSdkInfo;
    }

    @Override
    @NonNull
    public ImmutableList<File> getRepositories() {
        return this.mRepositories;
    }

    private DefaultSdkLoader(@NonNull File sdkLocation) {
        this.mSdkLocation = sdkLocation;
        this.mRepositories = this.computeRepositories();
    }

    private synchronized void init(@NonNull ILogger logger) {
        if (this.mSdkManager == null) {
            this.mSdkManager = SdkManager.createManager((String)this.mSdkLocation.getPath(), (ILogger)logger);
            if (this.mSdkManager == null) {
                throw new IllegalStateException("failed to parse SDK! Check console for details");
            }
            File toolsFolder = new File(this.mSdkLocation, "tools");
            File supportToolsFolder = new File(toolsFolder, "support");
            File platformTools = new File(this.mSdkLocation, "platform-tools");
            this.mSdkInfo = new SdkInfo(new File(supportToolsFolder, "annotations.jar"), new File(platformTools, SdkConstants.FN_ADB));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private FullRevision getPlatformToolsRevision(@NonNull File platformToolsFolder) {
        FullRevision fullRevision;
        if (!platformToolsFolder.isDirectory()) {
            return null;
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(new File(platformToolsFolder, "source.properties")), Charsets.UTF_8);
            Properties props = new Properties();
            props.load(reader);
            String value = props.getProperty("Pkg.Revision");
            fullRevision = FullRevision.parseRevision((String)value);
        }
        catch (FileNotFoundException ignore) {
            try {
                Closeables.close(reader, (boolean)true);
                return null;
            }
            catch (IOException e) {
                return null;
            }
            catch (IOException ignore2) {
                try {
                    Closeables.close(reader, (boolean)true);
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
                catch (NumberFormatException ignore3) {
                    try {
                        Closeables.close(reader, (boolean)true);
                        return null;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    catch (Throwable throwable) {
                        try {
                            Closeables.close(reader, (boolean)true);
                            throw throwable;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        try {
            Closeables.close((Closeable)reader, (boolean)true);
            return fullRevision;
        }
        catch (IOException e) {
            // empty catch block
        }
        return fullRevision;
    }

    @NonNull
    public ImmutableList<File> computeRepositories() {
        File googleRepo;
        ArrayList repositories = Lists.newArrayListWithExpectedSize((int)2);
        File androidRepo = new File(this.mSdkLocation, "extras" + File.separator + "android" + File.separator + "m2repository");
        if (androidRepo.isDirectory()) {
            repositories.add(androidRepo);
        }
        if ((googleRepo = new File(this.mSdkLocation, "extras" + File.separator + "google" + File.separator + "m2repository")).isDirectory()) {
            repositories.add(googleRepo);
        }
        return ImmutableList.copyOf((Collection)repositories);
    }
}

