/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.profile.ProcessRecorder;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ProcessRecorderFactory {
    private static boolean sENABLED = !Strings.isNullOrEmpty((String)System.getenv("RECORD_SPANS"));
    static final Object LOCK = new Object();
    static ProcessRecorderFactory sINSTANCE = new ProcessRecorderFactory();
    @Nullable
    private ProcessRecorder processRecorder = null;
    @Nullable
    private ProcessRecorder.ExecutionRecordWriter recordWriter = null;
    @Nullable
    private ILogger iLogger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() throws InterruptedException {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized()) {
                sINSTANCE.get().finish();
            }
            ProcessRecorderFactory.sINSTANCE.processRecorder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(ILogger logger, File out) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE.isInitialized() || !ProcessRecorderFactory.isEnabled()) {
                return;
            }
            sINSTANCE.setLogger(logger);
            sINSTANCE.setRecordWriter(new ProcessRecorder.JsonRecordWriter(new FileWriter(out)));
        }
    }

    static boolean isEnabled() {
        return sENABLED;
    }

    static void setEnabled(boolean enabled) {
        sENABLED = enabled;
    }

    public synchronized void setRecordWriter(@NonNull ProcessRecorder.ExecutionRecordWriter recordWriter) {
        this.assertRecorderNotCreated();
        this.recordWriter = recordWriter;
    }

    public synchronized void setLogger(@NonNull ILogger iLogger) {
        this.assertRecorderNotCreated();
        this.iLogger = iLogger;
    }

    public static ProcessRecorderFactory getFactory() {
        return sINSTANCE;
    }

    private boolean isInitialized() {
        return this.processRecorder != null;
    }

    private void assertRecorderNotCreated() {
        if (this.isInitialized()) {
            throw new RuntimeException("ProcessRecorder already created.");
        }
    }

    synchronized ProcessRecorder get() {
        if (this.processRecorder == null) {
            if (this.recordWriter == null) {
                throw new RuntimeException("recordWriter not configured.");
            }
            if (this.iLogger == null) {
                this.iLogger = new StdLogger(StdLogger.Level.INFO);
            }
            this.processRecorder = new ProcessRecorder(this.recordWriter, this.iLogger);
        }
        return this.processRecorder;
    }
}

