/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.signing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.SigningConfig;
import com.android.builder.signing.CertificateInfo;
import com.android.builder.signing.KeytoolException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.util.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public final class KeystoreHelper {
    private static final String CERTIFICATE_DESC = "CN=Android Debug,O=Android,C=US";

    @NonNull
    public static String defaultDebugKeystoreLocation() throws AndroidLocation.AndroidLocationException {
        String folder = AndroidLocation.getFolder();
        return folder + "debug.keystore";
    }

    public static boolean createDebugStore(@NonNull SigningConfig signingConfig, @NonNull ILogger logger) throws KeytoolException {
        return KeystoreHelper.createNewStore(signingConfig, CERTIFICATE_DESC, 30, logger);
    }

    private static boolean createNewStore(@NonNull SigningConfig signingConfig, @NonNull String description, int validityYears, final @NonNull ILogger logger) throws KeytoolException {
        String os = System.getProperty("os.name");
        String keytoolCommand = os.startsWith("Windows") ? "keytool.exe" : "keytool";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null && javaHome.length() > 0) {
            keytoolCommand = javaHome + File.separator + "bin" + File.separator + keytoolCommand;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(keytoolCommand);
        commandList.add("-genkey");
        commandList.add("-alias");
        commandList.add(signingConfig.getKeyAlias());
        commandList.add("-keyalg");
        commandList.add("RSA");
        commandList.add("-dname");
        commandList.add(description);
        commandList.add("-validity");
        commandList.add(Integer.toString(validityYears * 365));
        commandList.add("-keypass");
        commandList.add(signingConfig.getKeyPassword());
        commandList.add("-keystore");
        commandList.add(signingConfig.getStoreFile().getAbsolutePath());
        commandList.add("-storepass");
        commandList.add(signingConfig.getStorePassword());
        if (signingConfig.getStoreType() != null) {
            commandList.add("-storetype");
            commandList.add(signingConfig.getStoreType());
        }
        String[] commandArray = commandList.toArray(new String[commandList.size()]);
        int result = 0;
        try {
            Process process = Runtime.getRuntime().exec(commandArray);
            result = GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                public void out(@Nullable String line) {
                    if (line != null) {
                        logger.info(line, new Object[0]);
                    }
                }

                public void err(@Nullable String line) {
                    if (line != null) {
                        logger.error(null, line, new Object[0]);
                    }
                }
            });
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            boolean firstArg = true;
            for (String arg : commandArray) {
                boolean hasSpace;
                boolean bl = hasSpace = arg.indexOf(32) != -1;
                if (firstArg) {
                    firstArg = false;
                } else {
                    builder.append(' ');
                }
                if (hasSpace) {
                    builder.append('\"');
                }
                builder.append(arg);
                if (!hasSpace) continue;
                builder.append('\"');
            }
            throw new KeytoolException("Failed to create key: " + e.getMessage(), javaHome, builder.toString());
        }
        return result == 0;
    }

    public static CertificateInfo getCertificateInfo(@NonNull SigningConfig signingConfig) throws KeytoolException, FileNotFoundException {
        try {
            KeyStore keyStore = KeyStore.getInstance(signingConfig.getStoreType() != null ? signingConfig.getStoreType() : KeyStore.getDefaultType());
            FileInputStream fis = new FileInputStream(signingConfig.getStoreFile());
            keyStore.load(fis, signingConfig.getStorePassword().toCharArray());
            fis.close();
            char[] keyPassword = signingConfig.getKeyPassword().toCharArray();
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(signingConfig.getKeyAlias(), new KeyStore.PasswordProtection(keyPassword));
            if (entry != null) {
                return new CertificateInfo(entry.getPrivateKey(), (X509Certificate)entry.getCertificate());
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeytoolException(String.format("Failed to read key %1$s from store \"%2$s\": %3$s", signingConfig.getKeyAlias(), signingConfig.getStoreFile(), e.getMessage()), e);
        }
        return null;
    }
}

