/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentIdentifier;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DocumentIdentifierMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Date> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").build();
    private static final MarshallingInfo<String> VERSIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionName").build();
    private static final MarshallingInfo<List> PLATFORMTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformTypes").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").build();
    private static final MarshallingInfo<String> DOCUMENTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentFormat").build();
    private static final MarshallingInfo<String> TARGETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetType").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<List> REQUIRES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Requires").build();
    private static final MarshallingInfo<String> REVIEWSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReviewStatus").build();
    private static final MarshallingInfo<String> AUTHOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Author").build();
    private static final DocumentIdentifierMarshaller instance = new DocumentIdentifierMarshaller();

    public static DocumentIdentifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(DocumentIdentifier documentIdentifier, ProtocolMarshaller protocolMarshaller) {
        if (documentIdentifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentIdentifier.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getCreatedDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getOwner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getVersionName(), VERSIONNAME_BINDING);
            protocolMarshaller.marshall(documentIdentifier.getPlatformTypes(), PLATFORMTYPES_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getDocumentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getDocumentType(), DOCUMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getSchemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getDocumentFormat(), DOCUMENTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getTargetType(), TARGETTYPE_BINDING);
            protocolMarshaller.marshall(documentIdentifier.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall(documentIdentifier.getRequires(), REQUIRES_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getReviewStatus(), REVIEWSTATUS_BINDING);
            protocolMarshaller.marshall((Object)documentIdentifier.getAuthor(), AUTHOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

