/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.secretsmanager.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.secretsmanager.model.APIErrorType;
import com.amazonaws.services.secretsmanager.model.SecretValueEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetSecretValueResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SecretValueEntry> secretValues;
    private String nextToken;
    private List<APIErrorType> errors;

    public List<SecretValueEntry> getSecretValues() {
        return this.secretValues;
    }

    public void setSecretValues(Collection<SecretValueEntry> secretValues) {
        if (secretValues == null) {
            this.secretValues = null;
            return;
        }
        this.secretValues = new ArrayList<SecretValueEntry>(secretValues);
    }

    public BatchGetSecretValueResult withSecretValues(SecretValueEntry ... secretValues) {
        if (this.secretValues == null) {
            this.setSecretValues(new ArrayList<SecretValueEntry>(secretValues.length));
        }
        for (SecretValueEntry ele : secretValues) {
            this.secretValues.add(ele);
        }
        return this;
    }

    public BatchGetSecretValueResult withSecretValues(Collection<SecretValueEntry> secretValues) {
        this.setSecretValues(secretValues);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public BatchGetSecretValueResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<APIErrorType> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<APIErrorType> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<APIErrorType>(errors);
    }

    public BatchGetSecretValueResult withErrors(APIErrorType ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<APIErrorType>(errors.length));
        }
        for (APIErrorType ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public BatchGetSecretValueResult withErrors(Collection<APIErrorType> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecretValues() != null) {
            sb.append("SecretValues: ").append(this.getSecretValues()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSecretValueResult)) {
            return false;
        }
        BatchGetSecretValueResult other = (BatchGetSecretValueResult)obj;
        if (other.getSecretValues() == null ^ this.getSecretValues() == null) {
            return false;
        }
        if (other.getSecretValues() != null && !other.getSecretValues().equals(this.getSecretValues())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecretValues() == null ? 0 : this.getSecretValues().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public BatchGetSecretValueResult clone() {
        try {
            return (BatchGetSecretValueResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

