/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.OutputResolutionStackInput;
import com.amazonaws.services.sagemakergeospatial.model.transform.StackConfigInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StackConfigInput
implements Serializable,
Cloneable,
StructuredPojo {
    private OutputResolutionStackInput outputResolution;
    private List<String> targetBands;

    public void setOutputResolution(OutputResolutionStackInput outputResolution) {
        this.outputResolution = outputResolution;
    }

    public OutputResolutionStackInput getOutputResolution() {
        return this.outputResolution;
    }

    public StackConfigInput withOutputResolution(OutputResolutionStackInput outputResolution) {
        this.setOutputResolution(outputResolution);
        return this;
    }

    public List<String> getTargetBands() {
        return this.targetBands;
    }

    public void setTargetBands(Collection<String> targetBands) {
        if (targetBands == null) {
            this.targetBands = null;
            return;
        }
        this.targetBands = new ArrayList<String>(targetBands);
    }

    public StackConfigInput withTargetBands(String ... targetBands) {
        if (this.targetBands == null) {
            this.setTargetBands(new ArrayList<String>(targetBands.length));
        }
        for (String ele : targetBands) {
            this.targetBands.add(ele);
        }
        return this;
    }

    public StackConfigInput withTargetBands(Collection<String> targetBands) {
        this.setTargetBands(targetBands);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOutputResolution() != null) {
            sb.append("OutputResolution: ").append(this.getOutputResolution()).append(",");
        }
        if (this.getTargetBands() != null) {
            sb.append("TargetBands: ").append(this.getTargetBands());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackConfigInput)) {
            return false;
        }
        StackConfigInput other = (StackConfigInput)obj;
        if (other.getOutputResolution() == null ^ this.getOutputResolution() == null) {
            return false;
        }
        if (other.getOutputResolution() != null && !other.getOutputResolution().equals(this.getOutputResolution())) {
            return false;
        }
        if (other.getTargetBands() == null ^ this.getTargetBands() == null) {
            return false;
        }
        return other.getTargetBands() == null || other.getTargetBands().equals(this.getTargetBands());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOutputResolution() == null ? 0 : this.getOutputResolution().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBands() == null ? 0 : this.getTargetBands().hashCode());
        return hashCode;
    }

    public StackConfigInput clone() {
        try {
            return (StackConfigInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackConfigInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

