/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.transform.AudioMetadataMarshaller;
import java.io.Serializable;

public class AudioMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String codec;
    private Long durationMillis;
    private Long sampleRate;
    private Long numberOfChannels;

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getCodec() {
        return this.codec;
    }

    public AudioMetadata withCodec(String codec) {
        this.setCodec(codec);
        return this;
    }

    public void setDurationMillis(Long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public Long getDurationMillis() {
        return this.durationMillis;
    }

    public AudioMetadata withDurationMillis(Long durationMillis) {
        this.setDurationMillis(durationMillis);
        return this;
    }

    public void setSampleRate(Long sampleRate) {
        this.sampleRate = sampleRate;
    }

    public Long getSampleRate() {
        return this.sampleRate;
    }

    public AudioMetadata withSampleRate(Long sampleRate) {
        this.setSampleRate(sampleRate);
        return this;
    }

    public void setNumberOfChannels(Long numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
    }

    public Long getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public AudioMetadata withNumberOfChannels(Long numberOfChannels) {
        this.setNumberOfChannels(numberOfChannels);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCodec() != null) {
            sb.append("Codec: ").append(this.getCodec()).append(",");
        }
        if (this.getDurationMillis() != null) {
            sb.append("DurationMillis: ").append(this.getDurationMillis()).append(",");
        }
        if (this.getSampleRate() != null) {
            sb.append("SampleRate: ").append(this.getSampleRate()).append(",");
        }
        if (this.getNumberOfChannels() != null) {
            sb.append("NumberOfChannels: ").append(this.getNumberOfChannels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioMetadata)) {
            return false;
        }
        AudioMetadata other = (AudioMetadata)obj;
        if (other.getCodec() == null ^ this.getCodec() == null) {
            return false;
        }
        if (other.getCodec() != null && !other.getCodec().equals(this.getCodec())) {
            return false;
        }
        if (other.getDurationMillis() == null ^ this.getDurationMillis() == null) {
            return false;
        }
        if (other.getDurationMillis() != null && !other.getDurationMillis().equals(this.getDurationMillis())) {
            return false;
        }
        if (other.getSampleRate() == null ^ this.getSampleRate() == null) {
            return false;
        }
        if (other.getSampleRate() != null && !other.getSampleRate().equals(this.getSampleRate())) {
            return false;
        }
        if (other.getNumberOfChannels() == null ^ this.getNumberOfChannels() == null) {
            return false;
        }
        return other.getNumberOfChannels() == null || other.getNumberOfChannels().equals(this.getNumberOfChannels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCodec() == null ? 0 : this.getCodec().hashCode());
        hashCode = 31 * hashCode + (this.getDurationMillis() == null ? 0 : this.getDurationMillis().hashCode());
        hashCode = 31 * hashCode + (this.getSampleRate() == null ? 0 : this.getSampleRate().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfChannels() == null ? 0 : this.getNumberOfChannels().hashCode());
        return hashCode;
    }

    public AudioMetadata clone() {
        try {
            return (AudioMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

