/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearchserverless.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.opensearchserverless.model.CollectionType;
import com.amazonaws.services.opensearchserverless.model.StandbyReplicas;
import com.amazonaws.services.opensearchserverless.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCollectionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String description;
    private String name;
    private String standbyReplicas;
    private List<Tag> tags;
    private String type;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateCollectionRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateCollectionRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateCollectionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStandbyReplicas(String standbyReplicas) {
        this.standbyReplicas = standbyReplicas;
    }

    public String getStandbyReplicas() {
        return this.standbyReplicas;
    }

    public CreateCollectionRequest withStandbyReplicas(String standbyReplicas) {
        this.setStandbyReplicas(standbyReplicas);
        return this;
    }

    public CreateCollectionRequest withStandbyReplicas(StandbyReplicas standbyReplicas) {
        this.standbyReplicas = standbyReplicas.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateCollectionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateCollectionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateCollectionRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateCollectionRequest withType(CollectionType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStandbyReplicas() != null) {
            sb.append("StandbyReplicas: ").append(this.getStandbyReplicas()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionRequest)) {
            return false;
        }
        CreateCollectionRequest other = (CreateCollectionRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStandbyReplicas() == null ^ this.getStandbyReplicas() == null) {
            return false;
        }
        if (other.getStandbyReplicas() != null && !other.getStandbyReplicas().equals(this.getStandbyReplicas())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStandbyReplicas() == null ? 0 : this.getStandbyReplicas().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public CreateCollectionRequest clone() {
        return (CreateCollectionRequest)super.clone();
    }
}

