/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmonitor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.networkmonitor.model.Probe;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class ProbeMarshaller {
    private static final MarshallingInfo<String> PROBEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("probeId").build();
    private static final MarshallingInfo<String> PROBEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("probeArn").build();
    private static final MarshallingInfo<String> SOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceArn").build();
    private static final MarshallingInfo<String> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").build();
    private static final MarshallingInfo<Integer> DESTINATIONPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationPort").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final MarshallingInfo<Integer> PACKETSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("packetSize").build();
    private static final MarshallingInfo<String> ADDRESSFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("addressFamily").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpcId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> MODIFIEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("modifiedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final ProbeMarshaller instance = new ProbeMarshaller();

    public static ProbeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Probe probe, ProtocolMarshaller protocolMarshaller) {
        if (probe == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)probe.getProbeId(), PROBEID_BINDING);
            protocolMarshaller.marshall((Object)probe.getProbeArn(), PROBEARN_BINDING);
            protocolMarshaller.marshall((Object)probe.getSourceArn(), SOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)probe.getDestination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)probe.getDestinationPort(), DESTINATIONPORT_BINDING);
            protocolMarshaller.marshall((Object)probe.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)probe.getPacketSize(), PACKETSIZE_BINDING);
            protocolMarshaller.marshall((Object)probe.getAddressFamily(), ADDRESSFAMILY_BINDING);
            protocolMarshaller.marshall((Object)probe.getVpcId(), VPCID_BINDING);
            protocolMarshaller.marshall((Object)probe.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)probe.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)probe.getModifiedAt(), MODIFIEDAT_BINDING);
            protocolMarshaller.marshall(probe.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

