/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.managedblockchain;

import javax.annotation.Generated;

import com.amazonaws.services.managedblockchain.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonManagedBlockchain}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonManagedBlockchain implements AmazonManagedBlockchain {

    protected AbstractAmazonManagedBlockchain() {
    }

    @Override
    public CreateAccessorResult createAccessor(CreateAccessorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMemberResult createMember(CreateMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNetworkResult createNetwork(CreateNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNodeResult createNode(CreateNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateProposalResult createProposal(CreateProposalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccessorResult deleteAccessor(DeleteAccessorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMemberResult deleteMember(DeleteMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNodeResult deleteNode(DeleteNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccessorResult getAccessor(GetAccessorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMemberResult getMember(GetMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkResult getNetwork(GetNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNodeResult getNode(GetNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetProposalResult getProposal(GetProposalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccessorsResult listAccessors(ListAccessorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInvitationsResult listInvitations(ListInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNetworksResult listNetworks(ListNetworksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListNodesResult listNodes(ListNodesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProposalVotesResult listProposalVotes(ListProposalVotesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListProposalsResult listProposals(ListProposalsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectInvitationResult rejectInvitation(RejectInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMemberResult updateMember(UpdateMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNodeResult updateNode(UpdateNodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public VoteOnProposalResult voteOnProposal(VoteOnProposalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
