/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreatePolicyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String policyName;
    private String path;
    private String policyDocument;
    private String description;
    private SdkInternalList<Tag> tags;

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public CreatePolicyRequest withPolicyName(String policyName) {
        this.setPolicyName(policyName);
        return this;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public CreatePolicyRequest withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setPolicyDocument(String policyDocument) {
        this.policyDocument = policyDocument;
    }

    public String getPolicyDocument() {
        return this.policyDocument;
    }

    public CreatePolicyRequest withPolicyDocument(String policyDocument) {
        this.setPolicyDocument(policyDocument);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreatePolicyRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreatePolicyRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreatePolicyRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyName() != null) {
            sb.append("PolicyName: ").append(this.getPolicyName()).append(",");
        }
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getPolicyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.getPolicyDocument()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyRequest)) {
            return false;
        }
        CreatePolicyRequest other = (CreatePolicyRequest)obj;
        if (other.getPolicyName() == null ^ this.getPolicyName() == null) {
            return false;
        }
        if (other.getPolicyName() != null && !other.getPolicyName().equals(this.getPolicyName())) {
            return false;
        }
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getPolicyDocument() == null ^ this.getPolicyDocument() == null) {
            return false;
        }
        if (other.getPolicyDocument() != null && !other.getPolicyDocument().equals(this.getPolicyDocument())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyName() == null ? 0 : this.getPolicyName().hashCode());
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyDocument() == null ? 0 : this.getPolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreatePolicyRequest clone() {
        return (CreatePolicyRequest)super.clone();
    }
}

