/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.ContainerDefinition;
import com.amazonaws.services.gamelift.model.ContainerGroupDefinitionStatus;
import com.amazonaws.services.gamelift.model.ContainerOperatingSystem;
import com.amazonaws.services.gamelift.model.ContainerSchedulingStrategy;
import com.amazonaws.services.gamelift.model.transform.ContainerGroupDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ContainerGroupDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerGroupDefinitionArn;
    private Date creationTime;
    private String operatingSystem;
    private String name;
    private String schedulingStrategy;
    private Integer totalMemoryLimit;
    private Integer totalCpuLimit;
    private List<ContainerDefinition> containerDefinitions;
    private String status;
    private String statusReason;

    public void setContainerGroupDefinitionArn(String containerGroupDefinitionArn) {
        this.containerGroupDefinitionArn = containerGroupDefinitionArn;
    }

    public String getContainerGroupDefinitionArn() {
        return this.containerGroupDefinitionArn;
    }

    public ContainerGroupDefinition withContainerGroupDefinitionArn(String containerGroupDefinitionArn) {
        this.setContainerGroupDefinitionArn(containerGroupDefinitionArn);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public ContainerGroupDefinition withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public ContainerGroupDefinition withOperatingSystem(String operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this;
    }

    public ContainerGroupDefinition withOperatingSystem(ContainerOperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ContainerGroupDefinition withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSchedulingStrategy(String schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public ContainerGroupDefinition withSchedulingStrategy(String schedulingStrategy) {
        this.setSchedulingStrategy(schedulingStrategy);
        return this;
    }

    public ContainerGroupDefinition withSchedulingStrategy(ContainerSchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy.toString();
        return this;
    }

    public void setTotalMemoryLimit(Integer totalMemoryLimit) {
        this.totalMemoryLimit = totalMemoryLimit;
    }

    public Integer getTotalMemoryLimit() {
        return this.totalMemoryLimit;
    }

    public ContainerGroupDefinition withTotalMemoryLimit(Integer totalMemoryLimit) {
        this.setTotalMemoryLimit(totalMemoryLimit);
        return this;
    }

    public void setTotalCpuLimit(Integer totalCpuLimit) {
        this.totalCpuLimit = totalCpuLimit;
    }

    public Integer getTotalCpuLimit() {
        return this.totalCpuLimit;
    }

    public ContainerGroupDefinition withTotalCpuLimit(Integer totalCpuLimit) {
        this.setTotalCpuLimit(totalCpuLimit);
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        this.containerDefinitions = new ArrayList<ContainerDefinition>(containerDefinitions);
    }

    public ContainerGroupDefinition withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.containerDefinitions == null) {
            this.setContainerDefinitions(new ArrayList<ContainerDefinition>(containerDefinitions.length));
        }
        for (ContainerDefinition ele : containerDefinitions) {
            this.containerDefinitions.add(ele);
        }
        return this;
    }

    public ContainerGroupDefinition withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        this.setContainerDefinitions(containerDefinitions);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ContainerGroupDefinition withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ContainerGroupDefinition withStatus(ContainerGroupDefinitionStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public ContainerGroupDefinition withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerGroupDefinitionArn() != null) {
            sb.append("ContainerGroupDefinitionArn: ").append(this.getContainerGroupDefinitionArn()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getOperatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.getOperatingSystem()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSchedulingStrategy() != null) {
            sb.append("SchedulingStrategy: ").append(this.getSchedulingStrategy()).append(",");
        }
        if (this.getTotalMemoryLimit() != null) {
            sb.append("TotalMemoryLimit: ").append(this.getTotalMemoryLimit()).append(",");
        }
        if (this.getTotalCpuLimit() != null) {
            sb.append("TotalCpuLimit: ").append(this.getTotalCpuLimit()).append(",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: ").append(this.getContainerDefinitions()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupDefinition)) {
            return false;
        }
        ContainerGroupDefinition other = (ContainerGroupDefinition)obj;
        if (other.getContainerGroupDefinitionArn() == null ^ this.getContainerGroupDefinitionArn() == null) {
            return false;
        }
        if (other.getContainerGroupDefinitionArn() != null && !other.getContainerGroupDefinitionArn().equals(this.getContainerGroupDefinitionArn())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getOperatingSystem() == null ^ this.getOperatingSystem() == null) {
            return false;
        }
        if (other.getOperatingSystem() != null && !other.getOperatingSystem().equals(this.getOperatingSystem())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSchedulingStrategy() == null ^ this.getSchedulingStrategy() == null) {
            return false;
        }
        if (other.getSchedulingStrategy() != null && !other.getSchedulingStrategy().equals(this.getSchedulingStrategy())) {
            return false;
        }
        if (other.getTotalMemoryLimit() == null ^ this.getTotalMemoryLimit() == null) {
            return false;
        }
        if (other.getTotalMemoryLimit() != null && !other.getTotalMemoryLimit().equals(this.getTotalMemoryLimit())) {
            return false;
        }
        if (other.getTotalCpuLimit() == null ^ this.getTotalCpuLimit() == null) {
            return false;
        }
        if (other.getTotalCpuLimit() != null && !other.getTotalCpuLimit().equals(this.getTotalCpuLimit())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        return other.getStatusReason() == null || other.getStatusReason().equals(this.getStatusReason());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerGroupDefinitionArn() == null ? 0 : this.getContainerGroupDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystem() == null ? 0 : this.getOperatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSchedulingStrategy() == null ? 0 : this.getSchedulingStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getTotalMemoryLimit() == null ? 0 : this.getTotalMemoryLimit().hashCode());
        hashCode = 31 * hashCode + (this.getTotalCpuLimit() == null ? 0 : this.getTotalCpuLimit().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        return hashCode;
    }

    public ContainerGroupDefinition clone() {
        try {
            return (ContainerGroupDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerGroupDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

