/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.Backup;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class BackupMarshaller {
    private static final MarshallingInfo<String> BACKUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupId").build();
    private static final MarshallingInfo<String> LIFECYCLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lifecycle").build();
    private static final MarshallingInfo<StructuredPojo> FAILUREDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureDetails").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<Integer> PROGRESSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProgressPercent").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<StructuredPojo> FILESYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystem").build();
    private static final MarshallingInfo<StructuredPojo> DIRECTORYINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryInformation").build();
    private static final MarshallingInfo<String> OWNERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerId").build();
    private static final MarshallingInfo<String> SOURCEBACKUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceBackupId").build();
    private static final MarshallingInfo<String> SOURCEBACKUPREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceBackupRegion").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<StructuredPojo> VOLUME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Volume").build();
    private static final BackupMarshaller instance = new BackupMarshaller();

    public static BackupMarshaller getInstance() {
        return instance;
    }

    public void marshall(Backup backup, ProtocolMarshaller protocolMarshaller) {
        if (backup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)backup.getBackupId(), BACKUPID_BINDING);
            protocolMarshaller.marshall((Object)backup.getLifecycle(), LIFECYCLE_BINDING);
            protocolMarshaller.marshall((Object)backup.getFailureDetails(), FAILUREDETAILS_BINDING);
            protocolMarshaller.marshall((Object)backup.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)backup.getProgressPercent(), PROGRESSPERCENT_BINDING);
            protocolMarshaller.marshall((Object)backup.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)backup.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)backup.getResourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(backup.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)backup.getFileSystem(), FILESYSTEM_BINDING);
            protocolMarshaller.marshall((Object)backup.getDirectoryInformation(), DIRECTORYINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)backup.getOwnerId(), OWNERID_BINDING);
            protocolMarshaller.marshall((Object)backup.getSourceBackupId(), SOURCEBACKUPID_BINDING);
            protocolMarshaller.marshall((Object)backup.getSourceBackupRegion(), SOURCEBACKUPREGION_BINDING);
            protocolMarshaller.marshall((Object)backup.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)backup.getVolume(), VOLUME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

