/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.transform.CreateAggregateConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAggregateConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> aggregates;
    private Integer constituentsPerAggregate;

    public List<String> getAggregates() {
        return this.aggregates;
    }

    public void setAggregates(Collection<String> aggregates) {
        if (aggregates == null) {
            this.aggregates = null;
            return;
        }
        this.aggregates = new ArrayList<String>(aggregates);
    }

    public CreateAggregateConfiguration withAggregates(String ... aggregates) {
        if (this.aggregates == null) {
            this.setAggregates(new ArrayList<String>(aggregates.length));
        }
        for (String ele : aggregates) {
            this.aggregates.add(ele);
        }
        return this;
    }

    public CreateAggregateConfiguration withAggregates(Collection<String> aggregates) {
        this.setAggregates(aggregates);
        return this;
    }

    public void setConstituentsPerAggregate(Integer constituentsPerAggregate) {
        this.constituentsPerAggregate = constituentsPerAggregate;
    }

    public Integer getConstituentsPerAggregate() {
        return this.constituentsPerAggregate;
    }

    public CreateAggregateConfiguration withConstituentsPerAggregate(Integer constituentsPerAggregate) {
        this.setConstituentsPerAggregate(constituentsPerAggregate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAggregates() != null) {
            sb.append("Aggregates: ").append(this.getAggregates()).append(",");
        }
        if (this.getConstituentsPerAggregate() != null) {
            sb.append("ConstituentsPerAggregate: ").append(this.getConstituentsPerAggregate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAggregateConfiguration)) {
            return false;
        }
        CreateAggregateConfiguration other = (CreateAggregateConfiguration)obj;
        if (other.getAggregates() == null ^ this.getAggregates() == null) {
            return false;
        }
        if (other.getAggregates() != null && !other.getAggregates().equals(this.getAggregates())) {
            return false;
        }
        if (other.getConstituentsPerAggregate() == null ^ this.getConstituentsPerAggregate() == null) {
            return false;
        }
        return other.getConstituentsPerAggregate() == null || other.getConstituentsPerAggregate().equals(this.getConstituentsPerAggregate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAggregates() == null ? 0 : this.getAggregates().hashCode());
        hashCode = 31 * hashCode + (this.getConstituentsPerAggregate() == null ? 0 : this.getConstituentsPerAggregate().hashCode());
        return hashCode;
    }

    public CreateAggregateConfiguration clone() {
        try {
            return (CreateAggregateConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateAggregateConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

