/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.forecast.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.forecast.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * StatisticsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class StatisticsMarshaller {

    private static final MarshallingInfo<Integer> COUNT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Count").build();
    private static final MarshallingInfo<Integer> COUNTDISTINCT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountDistinct").build();
    private static final MarshallingInfo<Integer> COUNTNULL_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountNull").build();
    private static final MarshallingInfo<Integer> COUNTNAN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountNan").build();
    private static final MarshallingInfo<String> MIN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Min").build();
    private static final MarshallingInfo<String> MAX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Max").build();
    private static final MarshallingInfo<Double> AVG_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Avg").build();
    private static final MarshallingInfo<Double> STDDEV_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Stddev").build();
    private static final MarshallingInfo<Long> COUNTLONG_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CountLong").build();
    private static final MarshallingInfo<Long> COUNTDISTINCTLONG_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountDistinctLong").build();
    private static final MarshallingInfo<Long> COUNTNULLLONG_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CountNullLong").build();
    private static final MarshallingInfo<Long> COUNTNANLONG_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CountNanLong").build();

    private static final StatisticsMarshaller instance = new StatisticsMarshaller();

    public static StatisticsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(Statistics statistics, ProtocolMarshaller protocolMarshaller) {

        if (statistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(statistics.getCount(), COUNT_BINDING);
            protocolMarshaller.marshall(statistics.getCountDistinct(), COUNTDISTINCT_BINDING);
            protocolMarshaller.marshall(statistics.getCountNull(), COUNTNULL_BINDING);
            protocolMarshaller.marshall(statistics.getCountNan(), COUNTNAN_BINDING);
            protocolMarshaller.marshall(statistics.getMin(), MIN_BINDING);
            protocolMarshaller.marshall(statistics.getMax(), MAX_BINDING);
            protocolMarshaller.marshall(statistics.getAvg(), AVG_BINDING);
            protocolMarshaller.marshall(statistics.getStddev(), STDDEV_BINDING);
            protocolMarshaller.marshall(statistics.getCountLong(), COUNTLONG_BINDING);
            protocolMarshaller.marshall(statistics.getCountDistinctLong(), COUNTDISTINCTLONG_BINDING);
            protocolMarshaller.marshall(statistics.getCountNullLong(), COUNTNULLLONG_BINDING);
            protocolMarshaller.marshall(statistics.getCountNanLong(), COUNTNANLONG_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
