/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.InstanceRequirementsWithMetadataRequest;
import com.amazonaws.services.ec2.model.TargetCapacityUnitType;
import com.amazonaws.services.ec2.model.transform.GetSpotPlacementScoresRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetSpotPlacementScoresRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<GetSpotPlacementScoresRequest> {
    private SdkInternalList<String> instanceTypes;
    private Integer targetCapacity;
    private String targetCapacityUnitType;
    private Boolean singleAvailabilityZone;
    private SdkInternalList<String> regionNames;
    private InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata;
    private Integer maxResults;
    private String nextToken;

    public List<String> getInstanceTypes() {
        if (this.instanceTypes == null) {
            this.instanceTypes = new SdkInternalList();
        }
        return this.instanceTypes;
    }

    public void setInstanceTypes(Collection<String> instanceTypes) {
        if (instanceTypes == null) {
            this.instanceTypes = null;
            return;
        }
        this.instanceTypes = new SdkInternalList(instanceTypes);
    }

    public GetSpotPlacementScoresRequest withInstanceTypes(String ... instanceTypes) {
        if (this.instanceTypes == null) {
            this.setInstanceTypes((Collection<String>)new SdkInternalList(instanceTypes.length));
        }
        for (String ele : instanceTypes) {
            this.instanceTypes.add((Object)ele);
        }
        return this;
    }

    public GetSpotPlacementScoresRequest withInstanceTypes(Collection<String> instanceTypes) {
        this.setInstanceTypes(instanceTypes);
        return this;
    }

    public void setTargetCapacity(Integer targetCapacity) {
        this.targetCapacity = targetCapacity;
    }

    public Integer getTargetCapacity() {
        return this.targetCapacity;
    }

    public GetSpotPlacementScoresRequest withTargetCapacity(Integer targetCapacity) {
        this.setTargetCapacity(targetCapacity);
        return this;
    }

    public void setTargetCapacityUnitType(String targetCapacityUnitType) {
        this.targetCapacityUnitType = targetCapacityUnitType;
    }

    public String getTargetCapacityUnitType() {
        return this.targetCapacityUnitType;
    }

    public GetSpotPlacementScoresRequest withTargetCapacityUnitType(String targetCapacityUnitType) {
        this.setTargetCapacityUnitType(targetCapacityUnitType);
        return this;
    }

    public GetSpotPlacementScoresRequest withTargetCapacityUnitType(TargetCapacityUnitType targetCapacityUnitType) {
        this.targetCapacityUnitType = targetCapacityUnitType.toString();
        return this;
    }

    public void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
        this.singleAvailabilityZone = singleAvailabilityZone;
    }

    public Boolean getSingleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public GetSpotPlacementScoresRequest withSingleAvailabilityZone(Boolean singleAvailabilityZone) {
        this.setSingleAvailabilityZone(singleAvailabilityZone);
        return this;
    }

    public Boolean isSingleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public List<String> getRegionNames() {
        if (this.regionNames == null) {
            this.regionNames = new SdkInternalList();
        }
        return this.regionNames;
    }

    public void setRegionNames(Collection<String> regionNames) {
        if (regionNames == null) {
            this.regionNames = null;
            return;
        }
        this.regionNames = new SdkInternalList(regionNames);
    }

    public GetSpotPlacementScoresRequest withRegionNames(String ... regionNames) {
        if (this.regionNames == null) {
            this.setRegionNames((Collection<String>)new SdkInternalList(regionNames.length));
        }
        for (String ele : regionNames) {
            this.regionNames.add((Object)ele);
        }
        return this;
    }

    public GetSpotPlacementScoresRequest withRegionNames(Collection<String> regionNames) {
        this.setRegionNames(regionNames);
        return this;
    }

    public void setInstanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata) {
        this.instanceRequirementsWithMetadata = instanceRequirementsWithMetadata;
    }

    public InstanceRequirementsWithMetadataRequest getInstanceRequirementsWithMetadata() {
        return this.instanceRequirementsWithMetadata;
    }

    public GetSpotPlacementScoresRequest withInstanceRequirementsWithMetadata(InstanceRequirementsWithMetadataRequest instanceRequirementsWithMetadata) {
        this.setInstanceRequirementsWithMetadata(instanceRequirementsWithMetadata);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetSpotPlacementScoresRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetSpotPlacementScoresRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    @Override
    public Request<GetSpotPlacementScoresRequest> getDryRunRequest() {
        Request<GetSpotPlacementScoresRequest> request = new GetSpotPlacementScoresRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.getInstanceTypes()).append(",");
        }
        if (this.getTargetCapacity() != null) {
            sb.append("TargetCapacity: ").append(this.getTargetCapacity()).append(",");
        }
        if (this.getTargetCapacityUnitType() != null) {
            sb.append("TargetCapacityUnitType: ").append(this.getTargetCapacityUnitType()).append(",");
        }
        if (this.getSingleAvailabilityZone() != null) {
            sb.append("SingleAvailabilityZone: ").append(this.getSingleAvailabilityZone()).append(",");
        }
        if (this.getRegionNames() != null) {
            sb.append("RegionNames: ").append(this.getRegionNames()).append(",");
        }
        if (this.getInstanceRequirementsWithMetadata() != null) {
            sb.append("InstanceRequirementsWithMetadata: ").append(this.getInstanceRequirementsWithMetadata()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSpotPlacementScoresRequest)) {
            return false;
        }
        GetSpotPlacementScoresRequest other = (GetSpotPlacementScoresRequest)obj;
        if (other.getInstanceTypes() == null ^ this.getInstanceTypes() == null) {
            return false;
        }
        if (other.getInstanceTypes() != null && !other.getInstanceTypes().equals(this.getInstanceTypes())) {
            return false;
        }
        if (other.getTargetCapacity() == null ^ this.getTargetCapacity() == null) {
            return false;
        }
        if (other.getTargetCapacity() != null && !other.getTargetCapacity().equals(this.getTargetCapacity())) {
            return false;
        }
        if (other.getTargetCapacityUnitType() == null ^ this.getTargetCapacityUnitType() == null) {
            return false;
        }
        if (other.getTargetCapacityUnitType() != null && !other.getTargetCapacityUnitType().equals(this.getTargetCapacityUnitType())) {
            return false;
        }
        if (other.getSingleAvailabilityZone() == null ^ this.getSingleAvailabilityZone() == null) {
            return false;
        }
        if (other.getSingleAvailabilityZone() != null && !other.getSingleAvailabilityZone().equals(this.getSingleAvailabilityZone())) {
            return false;
        }
        if (other.getRegionNames() == null ^ this.getRegionNames() == null) {
            return false;
        }
        if (other.getRegionNames() != null && !other.getRegionNames().equals(this.getRegionNames())) {
            return false;
        }
        if (other.getInstanceRequirementsWithMetadata() == null ^ this.getInstanceRequirementsWithMetadata() == null) {
            return false;
        }
        if (other.getInstanceRequirementsWithMetadata() != null && !other.getInstanceRequirementsWithMetadata().equals(this.getInstanceRequirementsWithMetadata())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceTypes() == null ? 0 : this.getInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacity() == null ? 0 : this.getTargetCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTargetCapacityUnitType() == null ? 0 : this.getTargetCapacityUnitType().hashCode());
        hashCode = 31 * hashCode + (this.getSingleAvailabilityZone() == null ? 0 : this.getSingleAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getRegionNames() == null ? 0 : this.getRegionNames().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceRequirementsWithMetadata() == null ? 0 : this.getInstanceRequirementsWithMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetSpotPlacementScoresRequest clone() {
        return (GetSpotPlacementScoresRequest)super.clone();
    }
}

