/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.databasemigrationservice.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorDatabases" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteFleetAdvisorDatabasesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The IDs of the databases that the operation deleted.
     * </p>
     */
    private java.util.List<String> databaseIds;

    /**
     * <p>
     * The IDs of the databases that the operation deleted.
     * </p>
     * 
     * @return The IDs of the databases that the operation deleted.
     */

    public java.util.List<String> getDatabaseIds() {
        return databaseIds;
    }

    /**
     * <p>
     * The IDs of the databases that the operation deleted.
     * </p>
     * 
     * @param databaseIds
     *        The IDs of the databases that the operation deleted.
     */

    public void setDatabaseIds(java.util.Collection<String> databaseIds) {
        if (databaseIds == null) {
            this.databaseIds = null;
            return;
        }

        this.databaseIds = new java.util.ArrayList<String>(databaseIds);
    }

    /**
     * <p>
     * The IDs of the databases that the operation deleted.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDatabaseIds(java.util.Collection)} or {@link #withDatabaseIds(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param databaseIds
     *        The IDs of the databases that the operation deleted.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteFleetAdvisorDatabasesResult withDatabaseIds(String... databaseIds) {
        if (this.databaseIds == null) {
            setDatabaseIds(new java.util.ArrayList<String>(databaseIds.length));
        }
        for (String ele : databaseIds) {
            this.databaseIds.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The IDs of the databases that the operation deleted.
     * </p>
     * 
     * @param databaseIds
     *        The IDs of the databases that the operation deleted.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteFleetAdvisorDatabasesResult withDatabaseIds(java.util.Collection<String> databaseIds) {
        setDatabaseIds(databaseIds);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDatabaseIds() != null)
            sb.append("DatabaseIds: ").append(getDatabaseIds());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteFleetAdvisorDatabasesResult == false)
            return false;
        DeleteFleetAdvisorDatabasesResult other = (DeleteFleetAdvisorDatabasesResult) obj;
        if (other.getDatabaseIds() == null ^ this.getDatabaseIds() == null)
            return false;
        if (other.getDatabaseIds() != null && other.getDatabaseIds().equals(this.getDatabaseIds()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDatabaseIds() == null) ? 0 : getDatabaseIds().hashCode());
        return hashCode;
    }

    @Override
    public DeleteFleetAdvisorDatabasesResult clone() {
        try {
            return (DeleteFleetAdvisorDatabasesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
