/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurusecurity.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codegurusecurity.model.Recommendation;
import com.amazonaws.services.codegurusecurity.model.SuggestedFix;
import com.amazonaws.services.codegurusecurity.model.transform.RemediationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Remediation
implements Serializable,
Cloneable,
StructuredPojo {
    private Recommendation recommendation;
    private List<SuggestedFix> suggestedFixes;

    public void setRecommendation(Recommendation recommendation) {
        this.recommendation = recommendation;
    }

    public Recommendation getRecommendation() {
        return this.recommendation;
    }

    public Remediation withRecommendation(Recommendation recommendation) {
        this.setRecommendation(recommendation);
        return this;
    }

    public List<SuggestedFix> getSuggestedFixes() {
        return this.suggestedFixes;
    }

    public void setSuggestedFixes(Collection<SuggestedFix> suggestedFixes) {
        if (suggestedFixes == null) {
            this.suggestedFixes = null;
            return;
        }
        this.suggestedFixes = new ArrayList<SuggestedFix>(suggestedFixes);
    }

    public Remediation withSuggestedFixes(SuggestedFix ... suggestedFixes) {
        if (this.suggestedFixes == null) {
            this.setSuggestedFixes(new ArrayList<SuggestedFix>(suggestedFixes.length));
        }
        for (SuggestedFix ele : suggestedFixes) {
            this.suggestedFixes.add(ele);
        }
        return this;
    }

    public Remediation withSuggestedFixes(Collection<SuggestedFix> suggestedFixes) {
        this.setSuggestedFixes(suggestedFixes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecommendation() != null) {
            sb.append("Recommendation: ").append(this.getRecommendation()).append(",");
        }
        if (this.getSuggestedFixes() != null) {
            sb.append("SuggestedFixes: ").append(this.getSuggestedFixes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Remediation)) {
            return false;
        }
        Remediation other = (Remediation)obj;
        if (other.getRecommendation() == null ^ this.getRecommendation() == null) {
            return false;
        }
        if (other.getRecommendation() != null && !other.getRecommendation().equals(this.getRecommendation())) {
            return false;
        }
        if (other.getSuggestedFixes() == null ^ this.getSuggestedFixes() == null) {
            return false;
        }
        return other.getSuggestedFixes() == null || other.getSuggestedFixes().equals(this.getSuggestedFixes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecommendation() == null ? 0 : this.getRecommendation().hashCode());
        hashCode = 31 * hashCode + (this.getSuggestedFixes() == null ? 0 : this.getSuggestedFixes().hashCode());
        return hashCode;
    }

    public Remediation clone() {
        try {
            return (Remediation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RemediationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

