/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudtrail.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * Removes CloudTrail delegated administrator permissions from a specified member account in an organization that is
 * currently designated as a delegated administrator.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeregisterOrganizationDelegatedAdmin"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeregisterOrganizationDelegatedAdminRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A delegated administrator account ID. This is a member account in an organization that is currently designated as
     * a delegated administrator.
     * </p>
     */
    private String delegatedAdminAccountId;

    /**
     * <p>
     * A delegated administrator account ID. This is a member account in an organization that is currently designated as
     * a delegated administrator.
     * </p>
     * 
     * @param delegatedAdminAccountId
     *        A delegated administrator account ID. This is a member account in an organization that is currently
     *        designated as a delegated administrator.
     */

    public void setDelegatedAdminAccountId(String delegatedAdminAccountId) {
        this.delegatedAdminAccountId = delegatedAdminAccountId;
    }

    /**
     * <p>
     * A delegated administrator account ID. This is a member account in an organization that is currently designated as
     * a delegated administrator.
     * </p>
     * 
     * @return A delegated administrator account ID. This is a member account in an organization that is currently
     *         designated as a delegated administrator.
     */

    public String getDelegatedAdminAccountId() {
        return this.delegatedAdminAccountId;
    }

    /**
     * <p>
     * A delegated administrator account ID. This is a member account in an organization that is currently designated as
     * a delegated administrator.
     * </p>
     * 
     * @param delegatedAdminAccountId
     *        A delegated administrator account ID. This is a member account in an organization that is currently
     *        designated as a delegated administrator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeregisterOrganizationDelegatedAdminRequest withDelegatedAdminAccountId(String delegatedAdminAccountId) {
        setDelegatedAdminAccountId(delegatedAdminAccountId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDelegatedAdminAccountId() != null)
            sb.append("DelegatedAdminAccountId: ").append(getDelegatedAdminAccountId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeregisterOrganizationDelegatedAdminRequest == false)
            return false;
        DeregisterOrganizationDelegatedAdminRequest other = (DeregisterOrganizationDelegatedAdminRequest) obj;
        if (other.getDelegatedAdminAccountId() == null ^ this.getDelegatedAdminAccountId() == null)
            return false;
        if (other.getDelegatedAdminAccountId() != null && other.getDelegatedAdminAccountId().equals(this.getDelegatedAdminAccountId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDelegatedAdminAccountId() == null) ? 0 : getDelegatedAdminAccountId().hashCode());
        return hashCode;
    }

    @Override
    public DeregisterOrganizationDelegatedAdminRequest clone() {
        return (DeregisterOrganizationDelegatedAdminRequest) super.clone();
    }

}
