/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagentruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.bedrockagentruntime.model.S3ObjectDoc;

@SdkInternalApi
public class S3ObjectDocMarshaller {
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uri").build();
    private static final S3ObjectDocMarshaller instance = new S3ObjectDocMarshaller();

    public static S3ObjectDocMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ObjectDoc s3ObjectDoc, ProtocolMarshaller protocolMarshaller) {
        if (s3ObjectDoc == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ObjectDoc.getUri(), URI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

