/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagentruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagentruntime.model.ByteContentDoc;
import com.amazonaws.services.bedrockagentruntime.model.ExternalSourceType;
import com.amazonaws.services.bedrockagentruntime.model.S3ObjectDoc;
import com.amazonaws.services.bedrockagentruntime.model.transform.ExternalSourceMarshaller;
import java.io.Serializable;

public class ExternalSource
implements Serializable,
Cloneable,
StructuredPojo {
    private ByteContentDoc byteContent;
    private S3ObjectDoc s3Location;
    private String sourceType;

    public void setByteContent(ByteContentDoc byteContent) {
        this.byteContent = byteContent;
    }

    public ByteContentDoc getByteContent() {
        return this.byteContent;
    }

    public ExternalSource withByteContent(ByteContentDoc byteContent) {
        this.setByteContent(byteContent);
        return this;
    }

    public void setS3Location(S3ObjectDoc s3Location) {
        this.s3Location = s3Location;
    }

    public S3ObjectDoc getS3Location() {
        return this.s3Location;
    }

    public ExternalSource withS3Location(S3ObjectDoc s3Location) {
        this.setS3Location(s3Location);
        return this;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public ExternalSource withSourceType(String sourceType) {
        this.setSourceType(sourceType);
        return this;
    }

    public ExternalSource withSourceType(ExternalSourceType sourceType) {
        this.sourceType = sourceType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getByteContent() != null) {
            sb.append("ByteContent: ").append(this.getByteContent()).append(",");
        }
        if (this.getS3Location() != null) {
            sb.append("S3Location: ").append(this.getS3Location()).append(",");
        }
        if (this.getSourceType() != null) {
            sb.append("SourceType: ").append(this.getSourceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSource)) {
            return false;
        }
        ExternalSource other = (ExternalSource)obj;
        if (other.getByteContent() == null ^ this.getByteContent() == null) {
            return false;
        }
        if (other.getByteContent() != null && !other.getByteContent().equals(this.getByteContent())) {
            return false;
        }
        if (other.getS3Location() == null ^ this.getS3Location() == null) {
            return false;
        }
        if (other.getS3Location() != null && !other.getS3Location().equals(this.getS3Location())) {
            return false;
        }
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        return other.getSourceType() == null || other.getSourceType().equals(this.getSourceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getByteContent() == null ? 0 : this.getByteContent().hashCode());
        hashCode = 31 * hashCode + (this.getS3Location() == null ? 0 : this.getS3Location().hashCode());
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        return hashCode;
    }

    public ExternalSource clone() {
        try {
            return (ExternalSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExternalSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

