/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="feature-start", aggregator=true)
public class GitFlowFeatureStartMojo
extends AbstractGitFlowMojo {
    @Parameter(property="skipFeatureVersion", defaultValue="false")
    private boolean skipFeatureVersion = false;
    @Parameter
    private String featureNamePattern;
    @Parameter(property="pushRemote", defaultValue="false")
    private boolean pushRemote;
    @Parameter(property="featureName")
    private String featureName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(new String[0]);
        try {
            String currentVersion;
            String version;
            this.initGitFlowConfig();
            this.checkUncommittedChanges();
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCreate(this.gitFlowConfig.getDevelopmentBranch());
                this.gitFetchRemoteAndCompare(this.gitFlowConfig.getDevelopmentBranch());
            }
            String featureBranchName = null;
            if (this.settings.isInteractiveMode()) {
                try {
                    while (StringUtils.isBlank(featureBranchName)) {
                        featureBranchName = this.prompter.prompt("What is a name of feature branch? " + this.gitFlowConfig.getFeatureBranchPrefix());
                        if (this.validateBranchName(featureBranchName, this.featureNamePattern, false)) continue;
                        featureBranchName = null;
                    }
                }
                catch (PrompterException e) {
                    throw new MojoFailureException("feature-start", (Throwable)e);
                }
            } else {
                this.validateBranchName(this.featureName, this.featureNamePattern, true);
                featureBranchName = this.featureName;
            }
            if (StringUtils.isBlank(featureBranchName)) {
                throw new MojoFailureException("Feature name is blank.");
            }
            featureBranchName = StringUtils.deleteWhitespace(featureBranchName);
            boolean featureBranchExists = this.gitCheckBranchExists(this.gitFlowConfig.getFeatureBranchPrefix() + featureBranchName);
            if (featureBranchExists) {
                throw new MojoFailureException("Feature branch with that name already exists. Cannot start feature.");
            }
            this.gitCreateAndCheckout(this.gitFlowConfig.getFeatureBranchPrefix() + featureBranchName, this.gitFlowConfig.getDevelopmentBranch());
            if (!this.skipFeatureVersion && !this.tychoBuild && StringUtils.isNotBlank((String)(version = new GitFlowVersionInfo(currentVersion = this.getCurrentProjectVersion(), this.getVersionPolicy()).featureVersion(featureBranchName)))) {
                this.mvnSetVersions(version);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("version", version);
                properties.put("featureName", featureBranchName);
                this.gitCommit(this.commitMessages.getFeatureStartMessage(), properties);
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                this.gitPush(this.gitFlowConfig.getFeatureBranchPrefix() + featureBranchName, false);
            }
        }
        catch (VersionParseException | CommandLineException e) {
            throw new MojoFailureException("feature-start", e);
        }
    }

    private boolean validateBranchName(String name, String pattern, boolean failOnError) throws MojoFailureException, CommandLineException {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)name) && this.validBranchName(name)) {
            if (StringUtils.isNotBlank((String)pattern) && !name.matches(pattern)) {
                String error = "The name of the branch doesn't match '" + pattern + "' pattern.";
                this.getLog().warn((CharSequence)error);
                valid = false;
                if (failOnError) {
                    throw new MojoFailureException(error);
                }
            }
        } else {
            String error = "The name of the branch is not valid or blank.";
            this.getLog().warn((CharSequence)"The name of the branch is not valid or blank.");
            valid = false;
            if (failOnError) {
                throw new MojoFailureException("The name of the branch is not valid or blank.");
            }
        }
        return valid;
    }
}

