/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.context.event;

import com.alibaba.boot.dubbo.util.DubboUtils;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import java.util.Map;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@Order
public class OverrideDubboConfigApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        ConfigurableEnvironment environment = event.getEnvironment();
        boolean override = (Boolean)environment.getProperty("dubbo.config.override", Boolean.TYPE, (Object)true);
        if (override) {
            SortedMap<String, Object> dubboProperties = DubboUtils.filterDubboProperties(environment);
            ConfigUtils.getProperties().putAll((Map<?, ?>)dubboProperties);
            if (logger.isInfoEnabled()) {
                logger.info("Dubbo Config was overridden by externalized configuration {}", dubboProperties);
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("Disable override Dubbo Config caused by property {} = {}", (Object)"dubbo.config.override", (Object)override);
        }
    }
}

