/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.etcd.configuration;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="distributed.scheduler.etcd")
public class EtcdProperties {
    private String endpoints = "localhost:2379";
    private int maxInboundMessageSize = 0x6400000;
    private int requestTimeoutMs = 10000;
    private int sessionTimeoutMs = 60000;
    private String namingLoadCacheAtStart = "true";

    public String[] endpoints() {
        if (StringUtils.isBlank((CharSequence)this.endpoints)) {
            throw new IllegalArgumentException("Endpoints cannot be blank.");
        }
        return (String[])Arrays.stream(this.endpoints.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(e -> e.contains("://") ? e : "http://" + e).toArray(String[]::new);
    }

    public String getEndpoints() {
        return this.endpoints;
    }

    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public String getNamingLoadCacheAtStart() {
        return this.namingLoadCacheAtStart;
    }

    public void setEndpoints(String endpoints) {
        this.endpoints = endpoints;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public void setSessionTimeoutMs(int sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public void setNamingLoadCacheAtStart(String namingLoadCacheAtStart) {
        this.namingLoadCacheAtStart = namingLoadCacheAtStart;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EtcdProperties)) {
            return false;
        }
        EtcdProperties other = (EtcdProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxInboundMessageSize() != other.getMaxInboundMessageSize()) {
            return false;
        }
        if (this.getRequestTimeoutMs() != other.getRequestTimeoutMs()) {
            return false;
        }
        if (this.getSessionTimeoutMs() != other.getSessionTimeoutMs()) {
            return false;
        }
        String this$endpoints = this.getEndpoints();
        String other$endpoints = other.getEndpoints();
        if (this$endpoints == null ? other$endpoints != null : !this$endpoints.equals(other$endpoints)) {
            return false;
        }
        String this$namingLoadCacheAtStart = this.getNamingLoadCacheAtStart();
        String other$namingLoadCacheAtStart = other.getNamingLoadCacheAtStart();
        return !(this$namingLoadCacheAtStart == null ? other$namingLoadCacheAtStart != null : !this$namingLoadCacheAtStart.equals(other$namingLoadCacheAtStart));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EtcdProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxInboundMessageSize();
        result = result * 59 + this.getRequestTimeoutMs();
        result = result * 59 + this.getSessionTimeoutMs();
        String $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : $endpoints.hashCode());
        String $namingLoadCacheAtStart = this.getNamingLoadCacheAtStart();
        result = result * 59 + ($namingLoadCacheAtStart == null ? 43 : $namingLoadCacheAtStart.hashCode());
        return result;
    }

    public String toString() {
        return "EtcdProperties(endpoints=" + this.getEndpoints() + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", requestTimeoutMs=" + this.getRequestTimeoutMs() + ", sessionTimeoutMs=" + this.getSessionTimeoutMs() + ", namingLoadCacheAtStart=" + this.getNamingLoadCacheAtStart() + ")";
    }
}

