/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.randvarmulti.MultinormalGen;
import umontreal.ssj.randvarmulti.MultinormalPCAGen;
import umontreal.ssj.stochprocess.OrnsteinUhlenbeckProcess;

public class OrnsteinUhlenbeckWithIntegratedProcess
extends OrnsteinUhlenbeckProcess {
    double[] integratedPath;
    MultinormalGen[] normalsCorrGen;
    double[] bdt;
    double[] oneMExpMADtOverAlpha;
    double c22;

    public OrnsteinUhlenbeckWithIntegratedProcess(double x0, double alpha, double b, double sigma, NormalGen gen) {
        super(x0, alpha, b, sigma, gen);
    }

    @Override
    protected void initArrays(int d) {
        super.initArrays(d);
        this.integratedPath = new double[d + 1];
        this.bdt = new double[d];
        this.oneMExpMADtOverAlpha = new double[d];
        for (int iTime = 0; iTime < d; ++iTime) {
            double dt = this.t[iTime + 1] - this.t[iTime];
            this.bdt[iTime] = this.beta * dt;
            double oneMExpMADt = -Math.expm1(-this.alpha * dt);
            this.oneMExpMADtOverAlpha[iTime] = oneMExpMADt / this.alpha;
        }
        double c11 = this.sigma * this.sigma / 2.0 / this.alpha;
        double c12 = c11 / this.alpha;
        this.c22 = c12 / this.alpha;
        this.normalsCorrGen = new MultinormalGen[d];
        for (int iTime = 0; iTime < d; ++iTime) {
            double dt = this.t[iTime + 1] - this.t[iTime];
            double expMADt = this.alphadt[iTime];
            double oneMExpMADt = -Math.expm1(-this.alpha * dt);
            DenseDoubleMatrix2D covar = new DenseDoubleMatrix2D(2, 2);
            covar.set(0, 0, c11 * oneMExpMADt * (1.0 + expMADt));
            covar.set(0, 1, c12 * oneMExpMADt * oneMExpMADt);
            covar.set(1, 0, covar.get(0, 1));
            covar.set(1, 1, this.c22 * (-3.0 + 2.0 * this.alpha * dt + 4.0 * expMADt - expMADt * expMADt));
            double[] mu = new double[]{0.0, 0.0};
            this.normalsCorrGen[iTime] = new MultinormalPCAGen(this.gen, mu, (DoubleMatrix2D)covar);
        }
    }

    @Override
    public double[] generatePath() {
        this.path[0] = this.x0;
        this.integratedPath[0] = 0.0;
        double[] normalsCorr = new double[2];
        for (int iTime = 1; iTime <= this.d; ++iTime) {
            this.normalsCorrGen[iTime - 1].nextPoint(normalsCorr);
            this.path[iTime] = this.badt[iTime - 1] + this.path[iTime - 1] * this.alphadt[iTime - 1] + normalsCorr[0];
            this.integratedPath[iTime] = this.integratedPath[iTime - 1] + this.bdt[iTime - 1] + this.oneMExpMADtOverAlpha[iTime - 1] * (this.path[iTime - 1] - this.beta) + normalsCorr[1];
        }
        this.observationIndex = this.d;
        return this.path;
    }

    public double[] getIntegratedPath() {
        return this.integratedPath;
    }

    public double[] getExpectedFutureDiscount(double[] couponTimes) {
        double[] analyticNotificationDiscounts = new double[couponTimes.length];
        for (int iTime = 1; iTime < couponTimes.length; ++iTime) {
            int iTimePath = iTime < this.d ? iTime : this.d;
            double dt = couponTimes[iTime] - this.t[iTimePath];
            double expMADt = Math.exp(-this.alpha * dt);
            double mu_2 = this.beta * dt + (1.0 - expMADt) / this.alpha * (this.path[iTimePath] - this.beta);
            double sigma22 = this.c22 * (-3.0 + 2.0 * this.alpha * dt + 4.0 * expMADt - expMADt * expMADt);
            analyticNotificationDiscounts[iTime] = Math.exp(-mu_2 + sigma22 / 2.0 - this.integratedPath[iTimePath]);
        }
        return analyticNotificationDiscounts;
    }

    public double[] getTotalAnalyticDiscount(double[] times) {
        double[] analyticDiscount = new double[times.length];
        analyticDiscount[0] = 1.0;
        for (int iTime = 1; iTime < times.length; ++iTime) {
            double dt = times[iTime] - times[0];
            double expMADt = Math.exp(-this.alpha * dt);
            double mu_2 = this.beta * dt + (1.0 - expMADt) / this.alpha * (this.x0 - this.beta);
            double sigma22 = this.c22 * (-3.0 + 2.0 * this.alpha * dt + 4.0 * expMADt - expMADt * expMADt);
            analyticDiscount[iTime] = Math.exp(-mu_2 + sigma22 / 2.0);
        }
        return analyticDiscount;
    }
}

