/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.mcqmctools.anova;

import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.mcqmctools.MonteCarloModel;
import umontreal.ssj.mcqmctools.MonteCarloModelDouble;
import umontreal.ssj.mcqmctools.anova.ObservationCollector;
import umontreal.ssj.mcqmctools.anova.Sampler;
import umontreal.ssj.stat.Tally;

public class QMCSampler
implements Sampler {
    protected PointSet points;

    public QMCSampler(PointSet points) {
        this.points = points;
    }

    public PointSet getPointSet() {
        return this.points;
    }

    @Override
    public int getNumSimulationsPerSample() {
        return 1;
    }

    @Override
    public int getNumSamples() {
        return this.points.getNumPoints();
    }

    @Override
    public <E> void simulateRuns(MonteCarloModel<? extends E> model, ObservationCollector<E> collector) {
        PointSetIterator it = this.points.iterator();
        while (it.hasNextPoint()) {
            model.simulate(it);
            collector.observe(model.getPerformance());
            it.resetToNextPoint();
        }
    }

    @Override
    public void simulateRuns(MonteCarloModelDouble model, Tally collector) {
        PointSetIterator it = this.points.iterator();
        while (it.hasNextPoint()) {
            model.simulate(it);
            collector.add(model.getPerformance());
            it.resetToNextPoint();
        }
    }

    public String toString() {
        return "QMC Sampler [nPoints=" + this.points.getNumPoints() + "] [points=" + this.points.getClass().getSimpleName() + "]";
    }
}

