/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.latnetbuilder.weights;

import java.util.ArrayList;
import java.util.List;
import umontreal.ssj.latnetbuilder.weights.SingletonWeight;

public abstract class Weights<T> {
    protected double defaultWeight = 0.0;
    protected ArrayList<SingletonWeight<T>> weights;

    public Weights(List<SingletonWeight<T>> w) {
        this.weights = new ArrayList<SingletonWeight<T>>(w);
    }

    public Weights() {
        this.weights = new ArrayList();
    }

    public ArrayList<SingletonWeight<T>> getWeights() {
        return this.weights;
    }

    public void setDefaultWeight(double dWeight) {
        this.defaultWeight = dWeight;
    }

    public double getDefaultWeight() {
        return this.defaultWeight;
    }

    public void add(SingletonWeight<T> singletonWeight) {
        boolean added = false;
        for (SingletonWeight<T> w : this.weights) {
            if (w.getIndex() != singletonWeight.getIndex() || added) continue;
            this.weights.set(this.weights.indexOf(w), singletonWeight);
            added = true;
        }
        if (!added) {
            this.weights.add(singletonWeight);
        }
    }

    public void add(T index, double weight) {
        this.add(new SingletonWeight<T>(index, weight));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append("Weights [default = " + this.getDefaultWeight() + "]\n");
        sb.append("[");
        for (SingletonWeight<T> w : this.weights) {
            sb.append(w.getWeight() + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]\n");
        return sb.toString();
    }

    public abstract String toLatNetBuilder();
}

