/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.charts;

import java.awt.Paint;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import umontreal.ssj.charts.XYListSeriesCollection;

public class YListSeriesCollection
extends XYListSeriesCollection {
    private void initYListSeries(double h, double[] data, int numPoints) {
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.seriesCollection = new XYSeriesCollection();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        XYSeries serie = new XYSeries((Comparable)((Object)" "));
        for (int j = 0; j < numPoints; ++j) {
            serie.add(h * (double)(j + 1), data[j]);
        }
        tempSeriesCollection.addSeries(serie);
        this.renderer.setSeriesPaint(0, (Paint)YListSeriesCollection.getDefaultColor(0));
        this.plotStyle = new String[1];
        this.marksType = new String[1];
        this.dashPattern = new String[1];
        this.marksType[0] = " ";
        this.plotStyle[0] = "smooth";
        this.dashPattern[0] = "solid";
    }

    private void initYListSeries(boolean flag, double[] ... data) {
        int i;
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.seriesCollection = new XYSeriesCollection();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        for (int i2 = 0; i2 < data.length; ++i2) {
            XYSeries serie = new XYSeries((Comparable)((Object)" "));
            double h = flag ? 1.0 : 1.0 / (double)data[i2].length;
            for (int j = 0; j < data[i2].length; ++j) {
                serie.add(h * (double)(j + 1), data[i2][j]);
            }
            tempSeriesCollection.addSeries(serie);
        }
        int s = tempSeriesCollection.getSeriesCount();
        for (i = 0; i < s; ++i) {
            this.renderer.setSeriesPaint(i, (Paint)YListSeriesCollection.getDefaultColor(i));
        }
        this.plotStyle = new String[s];
        this.marksType = new String[s];
        this.dashPattern = new String[s];
        for (i = 0; i < s; ++i) {
            this.marksType[i] = " ";
            this.plotStyle[i] = "smooth";
            this.dashPattern[i] = "solid";
        }
    }

    public YListSeriesCollection(double[] ... data) {
        this.initYListSeries(true, data);
    }

    public YListSeriesCollection(boolean flag, double[] ... data) {
        this.initYListSeries(flag, data);
    }

    public YListSeriesCollection(double[] data, int numPoints) {
        this.initYListSeries(1.0, data, numPoints);
    }

    public YListSeriesCollection(double h, double[] data, int numPoints) {
        this.initYListSeries(h, data, numPoints);
    }

    public YListSeriesCollection(double[][] data, int numPoints) {
        int i;
        this.renderer = new XYLineAndShapeRenderer(true, false);
        this.seriesCollection = new XYSeriesCollection();
        XYSeriesCollection tempSeriesCollection = (XYSeriesCollection)this.seriesCollection;
        for (int i2 = 0; i2 < data.length; ++i2) {
            XYSeries serie = new XYSeries((Comparable)((Object)" "));
            for (int j = 0; j < numPoints; ++j) {
                serie.add((double)(j + 1), data[i2][j]);
            }
            tempSeriesCollection.addSeries(serie);
        }
        int s = tempSeriesCollection.getSeriesCount();
        for (i = 0; i < s; ++i) {
            this.renderer.setSeriesPaint(i, (Paint)YListSeriesCollection.getDefaultColor(i));
        }
        this.plotStyle = new String[s];
        this.marksType = new String[s];
        this.dashPattern = new String[s];
        for (i = 0; i < s; ++i) {
            this.marksType[i] = " ";
            this.plotStyle[i] = "smooth";
            this.dashPattern[i] = "solid";
        }
    }
}

