/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.density;

import java.util.ArrayList;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.stat.PgfDataTable;

public abstract class DensityEstimator {
    protected double[] data;

    public abstract void setData(double[] var1);

    public double[] getData() {
        return this.data;
    }

    public abstract double evalDensity(double var1);

    public double[] evalDensity(double[] evalPoints) {
        int k = evalPoints.length;
        double[] dens = new double[k];
        for (int j = 0; j < k; ++j) {
            dens[j] = this.evalDensity(evalPoints[j]);
        }
        return dens;
    }

    public double[] evalDensity(double[] evalPoints, double[] data) {
        this.setData(data);
        return this.evalDensity(evalPoints);
    }

    public double[][] evalDensity(double[] evalPoints, double[][] data) {
        int m = data.length;
        double[][] density = new double[m][];
        for (int r = 0; r < m; ++r) {
            density[r] = this.evalDensity(evalPoints, data[r]);
        }
        return density;
    }

    public static void evalDensity(ArrayList<DensityEstimator> listDE, double[] evalPoints, double[][] data, ArrayList<double[][]> listDensity) {
        for (DensityEstimator de : listDE) {
            listDensity.add(de.evalDensity(evalPoints, data));
        }
    }

    public static double[] computeVariance(double[][] density) {
        int m = density.length;
        int k = density[0].length;
        double[] meanDens = new double[k];
        double[] varDens = new double[k];
        for (int r = 0; r < m; ++r) {
            for (int j = 0; j < k; ++j) {
                double x = density[r][j];
                double y = x - meanDens[j];
                int n = j;
                meanDens[n] = meanDens[n] + y / (double)(r + 1);
                int n2 = j;
                varDens[n2] = varDens[n2] + y * (x - meanDens[j]);
            }
        }
        int j = 0;
        while (j < k) {
            int n = j++;
            varDens[n] = varDens[n] / (double)(m - 1);
        }
        return varDens;
    }

    public static double computeIV(double[][] density, double a, double b, double[] variance) {
        variance = DensityEstimator.computeVariance(density);
        int k = density[0].length;
        double iv = 0.0;
        for (double var : variance) {
            iv += var;
        }
        return iv * (b - a) / (double)k;
    }

    public static void computeIV(ArrayList<double[][]> listDensity, double a, double b, ArrayList<Double> listIV) {
        int k = listDensity.get(0)[0].length;
        double[] variance = new double[k];
        for (double[][] density : listDensity) {
            listIV.add(DensityEstimator.computeIV(density, a, b, variance));
        }
    }

    public static double[] computeMISE(ContinuousDistribution dist, double[] evalPoints, double[][] density, double a, double b, double[] variance, double[] sqBias, double[] mse) {
        int m = density.length;
        int k = evalPoints.length;
        double[] meanDens = new double[k];
        for (int r = 0; r < m; ++r) {
            int j = 0;
            while (j < k) {
                double x = density[r][j];
                double y = x - meanDens[j];
                double trueDensity = dist.density(evalPoints[j]);
                double z = x - trueDensity;
                int n = j;
                meanDens[n] = meanDens[n] + y / (double)(r + 1);
                int n2 = j;
                variance[n2] = variance[n2] + y * (x - meanDens[j]);
                int n3 = j++;
                mse[n3] = mse[n3] + z * z;
            }
        }
        double iv = 0.0;
        double mise = 0.0;
        for (int j = 0; j < k; ++j) {
            int n = j;
            variance[n] = variance[n] / ((double)m - 1.0);
            int n4 = j;
            mse[n4] = mse[n4] / (double)m;
            sqBias[j] = mse[j] - variance[j];
            iv += variance[j];
            mise += mse[j];
        }
        double fact = (b - a) / (double)k;
        double[] res = new double[]{iv *= fact, (mise *= (b - a) / (double)k) - iv, mise};
        return res;
    }

    public static void computeMISE(ContinuousDistribution dist, double[] evalPoints, ArrayList<double[][]> listDensity, double a, double b, ArrayList<double[]> listMISE) {
        int k = evalPoints.length;
        double[] tmp = new double[k];
        for (double[][] density : listDensity) {
            listMISE.add(DensityEstimator.computeMISE(dist, evalPoints, density, a, b, tmp, tmp, tmp));
        }
    }

    public abstract String toString();

    public static String plotDensity(double[] evalPoints, double[] density, String plotTitle, String[] axisTitles) {
        double[][] plotData = new double[][]{evalPoints, density};
        PgfDataTable table = new PgfDataTable(plotTitle, "", axisTitles, plotData);
        StringBuffer sb = new StringBuffer("");
        sb.append(PgfDataTable.pgfplotFileHeader());
        sb.append(table.drawPgfPlotSingleCurve(plotTitle, "axis", 0, 1, -1, "", ""));
        sb.append(PgfDataTable.pgfplotEndDocument());
        return sb.toString();
    }

    public static double roughnessFunctional(double[] density, double a, double b) {
        double fac = (b - a) / (double)density.length;
        double sum = 0.0;
        for (double d : density) {
            sum += d * d;
        }
        return fac * sum;
    }
}

