/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.simexp;

import umontreal.ssj.simevents.Simulator;
import umontreal.ssj.stat.FunctionOfMultipleMeansTally;
import umontreal.ssj.stat.StatProbe;
import umontreal.ssj.stat.Tally;

public abstract class SimExp {
    protected Simulator sim;
    protected boolean simulating = false;

    protected SimExp() {
        this(Simulator.getDefaultSimulator());
    }

    protected SimExp(Simulator sim) {
        if (sim == null) {
            throw new NullPointerException();
        }
        this.sim = sim;
    }

    public final Simulator simulator() {
        return this.sim;
    }

    public final void setSimulator(Simulator sim) {
        if (sim == null) {
            throw new NullPointerException();
        }
        if (this.simulating) {
            throw new UnsupportedOperationException("Unable to set Simulator, experiment object already running");
        }
        this.sim = sim;
    }

    public boolean isSimulating() {
        return this.simulating;
    }

    public abstract void simulate();

    public static int getRequiredNewObservations(StatProbe[] a, double targetError, double level) {
        int nnewobs = 0;
        for (StatProbe sp : a) {
            int re;
            int n = re = sp == null ? 0 : SimExp.getRequiredNewObservations(sp, targetError, level);
            if (re <= nnewobs) continue;
            nnewobs = re;
        }
        return nnewobs;
    }

    public static int getRequiredNewObservations(Iterable<? extends StatProbe> it, double targetError, double level) {
        int nnewobs = 0;
        for (StatProbe statProbe : it) {
            int re = statProbe == null ? 0 : SimExp.getRequiredNewObservations(statProbe, targetError, level);
            if (re <= nnewobs) continue;
            nnewobs = re;
        }
        return nnewobs;
    }

    public static int getRequiredNewObservations(StatProbe probe, double targetError, double level) {
        if (probe instanceof Tally) {
            return SimExp.getRequiredNewObservationsTally((Tally)probe, targetError, level);
        }
        if (probe instanceof FunctionOfMultipleMeansTally) {
            return SimExp.getRequiredNewObservationsTally((FunctionOfMultipleMeansTally)probe, targetError, level);
        }
        return 0;
    }

    public static int getRequiredNewObservationsTally(Tally ta, double targetError, double level) {
        double[] cr = new double[2];
        int no = ta.numberObs();
        if (no >= 2) {
            ta.confidenceIntervalStudent(level, cr);
        }
        return SimExp.getRequiredNewObservations(cr[0], cr[1], no, targetError);
    }

    public static int getRequiredNewObservationsTally(FunctionOfMultipleMeansTally fmmt, double targetError, double level) {
        double[] cr = new double[2];
        int no = fmmt.numberObs();
        if (no >= 2) {
            fmmt.confidenceIntervalDelta(level, cr);
        }
        return SimExp.getRequiredNewObservations(cr[0], cr[1], no, targetError);
    }

    public static int getRequiredNewObservations(double center, double radius, int numberObs, double targetError) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius must not be negative");
        }
        if (targetError < 0.0) {
            throw new IllegalArgumentException("The target error must not be negative");
        }
        if (numberObs < 1) {
            return 0;
        }
        double targetRadius = targetError * Math.abs(center);
        if (radius <= targetRadius) {
            return 0;
        }
        double deltan = radius * Math.sqrt(numberObs);
        double sqrtnp = deltan / targetRadius;
        double totalnobs = sqrtnp * sqrtnp;
        int nn = (int)Math.round(totalnobs) - numberObs;
        if (nn < 0) {
            return 0;
        }
        return nn;
    }
}

