/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.charts;

import javax.swing.JFrame;
import umontreal.ssj.charts.XYLineChart;
import umontreal.ssj.probdist.ContinuousDistribution;

public class ContinuousDistChart {
    protected ContinuousDistribution dist;
    protected double a;
    protected double b;
    protected int m;
    protected XYLineChart cdfChart;
    protected XYLineChart densityChart;

    private void init() {
        block6: {
            double x;
            int i;
            double[][] cdf = new double[2][this.m + 1];
            double[][] density = new double[2][this.m + 1];
            double h = (this.b - this.a) / (double)this.m;
            int coex = 0;
            try {
                for (i = 0; i <= this.m; ++i) {
                    cdf[0][i] = x = this.a + (double)i * h;
                    cdf[1][i] = this.dist.cdf(x);
                }
                this.cdfChart = new XYLineChart("cdf: " + this.dist.toString(), "", "", new double[][][]{cdf});
            }
            catch (UnsupportedOperationException e) {
                ++coex;
                System.err.println(e);
            }
            try {
                for (i = 0; i <= this.m; ++i) {
                    density[0][i] = x = this.a + (double)i * h;
                    density[1][i] = this.dist.density(x);
                }
                this.densityChart = new XYLineChart("density: " + this.dist.toString(), "", "", new double[][][]{density});
            }
            catch (UnsupportedOperationException e) {
                System.err.println(e);
                if (coex != 1) break block6;
                throw e;
            }
        }
        this.cdfChart.setprobFlag(true);
        this.densityChart.setprobFlag(true);
    }

    public ContinuousDistChart(ContinuousDistribution dist, double a, double b, int m) {
        this.dist = dist;
        this.a = a;
        this.b = b;
        this.m = m;
        this.init();
    }

    public JFrame viewCdf(int width, int height) {
        return this.cdfChart.view(width, height);
    }

    public JFrame viewDensity(int width, int height) {
        return this.densityChart.view(width, height);
    }

    public String toLatexCdf(int width, int height) {
        return this.cdfChart.toLatex(width, height);
    }

    public String toLatexDensity(int width, int height) {
        return this.densityChart.toLatex(width, height);
    }

    public void setParam(double a, double b, int m) {
        this.a = a;
        this.b = b;
        this.m = m;
        this.init();
    }
}

