/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.sort;

import java.util.Arrays;
import umontreal.ssj.util.sort.DoubleArrayComparator;
import umontreal.ssj.util.sort.MultiDimComparable;
import umontreal.ssj.util.sort.MultiDimComparator;
import umontreal.ssj.util.sort.MultiDimSortComparable;

public class SplitSort<T extends MultiDimComparable<? super T>>
implements MultiDimSortComparable<T> {
    private int dimension;

    public SplitSort(int d) {
        this.dimension = d;
    }

    @Override
    public void sort(T[] a, int iMin, int iMax) {
        if (this.dimension == 1) {
            Arrays.sort(a, iMin, iMax, new MultiDimComparator(0));
        } else {
            this.splitSort((MultiDimComparable[])a, iMin, iMax, 0);
        }
    }

    private void splitSort(T[] a, int iMin, int iMax, int splitCoord) {
        if (iMin == iMax - 1) {
            return;
        }
        Arrays.sort(a, iMin, iMax, new MultiDimComparator(splitCoord));
        int iMid = (iMin + iMax) / 2;
        this.splitSort((MultiDimComparable[])a, iMin, iMid, (splitCoord + 1) % this.dimension);
        this.splitSort((MultiDimComparable[])a, iMid, iMax, (splitCoord + 1) % this.dimension);
    }

    @Override
    public void sort(T[] a) {
        this.sort((MultiDimComparable[])a, 0, a.length);
    }

    @Override
    public void sort(double[][] a, int iMin, int iMax) {
        if (this.dimension == 1) {
            Arrays.sort(a, iMin, iMax, new DoubleArrayComparator(0));
        } else {
            this.splitSort(a, iMin, iMax, 0);
        }
    }

    private void splitSort(double[][] a, int iMin, int iMax, int splitCoord) {
        if (iMin == iMax - 1) {
            return;
        }
        Arrays.sort(a, iMin, iMax, new DoubleArrayComparator(splitCoord));
        int iMid = (iMin + iMax) / 2;
        this.splitSort(a, iMin, iMid, (splitCoord + 1) % this.dimension);
        this.splitSort(a, iMid, iMax, (splitCoord + 1) % this.dimension);
    }

    @Override
    public void sort(double[][] a) {
        this.sort(a, 0, a.length);
    }

    @Override
    public int dimension() {
        return this.dimension;
    }
}

