/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.sort;

import java.util.Arrays;
import umontreal.ssj.util.sort.DoubleArrayComparator;
import umontreal.ssj.util.sort.MultiDimComparable;
import umontreal.ssj.util.sort.MultiDimComparator;
import umontreal.ssj.util.sort.MultiDimSortComparable;

public class OneDimSort<T extends MultiDimComparable<? super T>>
implements MultiDimSortComparable<T> {
    private int j;
    private int d;

    public OneDimSort(int j, int d) {
        if (j < 0 || j >= d) {
            throw new IllegalArgumentException("sortCoordinate from 0 to " + d + " - 1.");
        }
        this.j = j;
        this.d = d;
    }

    public OneDimSort(int j) {
        this(j, j + 1);
    }

    @Override
    public void sort(T[] a, int iMin, int iMax) {
        Arrays.sort(a, iMin, iMax, new MultiDimComparator(this.j));
    }

    @Override
    public void sort(T[] a) {
        this.sort((MultiDimComparable[])a, 0, a.length);
    }

    @Override
    public void sort(double[][] a, int iMin, int iMax) {
        Arrays.sort(a, iMin, iMax, new DoubleArrayComparator(this.j));
    }

    @Override
    public void sort(double[][] a) {
        this.sort(a, 0, a.length);
    }

    public int getSortCoordinate() {
        return this.j;
    }

    @Override
    public int dimension() {
        return this.d;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": d = " + this.d + ", sort coordinate (starts at 0) = " + this.j;
    }
}

