/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.StochasticProcess;

public abstract class GeometricLevyProcess
extends StochasticProcess {
    protected StochasticProcess levyProcess;
    protected double omegaRiskNeutralCorrection;
    protected double muGeom;
    protected double[] muGeomRNdt;
    protected double[] muGeomRNdT;

    @Override
    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            int i;
            this.levyProcess.setObservationTimes(this.t, this.d);
            this.observationIndexFromCounter = this.levyProcess.getArrayMappingCounterToIndex();
            this.muGeomRNdt = new double[this.d];
            for (i = 0; i < this.d; ++i) {
                this.muGeomRNdt[i] = (this.muGeom - this.omegaRiskNeutralCorrection) * (this.t[i + 1] - this.t[i]);
            }
            this.muGeomRNdT = new double[this.d + 1];
            for (i = 0; i <= this.d; ++i) {
                this.muGeomRNdT[i] = (this.muGeom - this.omegaRiskNeutralCorrection) * (this.t[i] - this.t[0]);
            }
        }
    }

    @Override
    public double[] generatePath() {
        double s = this.x0;
        this.resetStartProcess();
        double[] arithmPath = this.levyProcess.generatePath();
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s *= Math.exp(this.muGeomRNdt[i] + arithmPath[i + 1] - arithmPath[i]);
        }
        this.observationIndex = this.d;
        return this.path;
    }

    @Override
    public double nextObservation() {
        double levy = this.levyProcess.nextObservation();
        this.observationIndex = this.levyProcess.getCurrentObservationIndex();
        this.path[this.observationIndex] = this.x0 * Math.exp(this.muGeomRNdT[this.observationIndex] + levy);
        return this.path[this.observationIndex];
    }

    @Override
    public void resetStartProcess() {
        super.init();
        this.levyProcess.resetStartProcess();
    }

    @Override
    public void setObservationTimes(double[] time, int d) {
        super.setObservationTimes(time, d);
        this.levyProcess.setObservationTimes(time, d);
    }

    public double getOmega() {
        return this.omegaRiskNeutralCorrection;
    }

    public double getMuGeom() {
        return this.muGeom;
    }

    public void setMuGeom(double muGeom) {
        this.muGeom = muGeom;
    }

    public StochasticProcess getLevyProcess() {
        return this.levyProcess;
    }

    public void resetRiskNeutralCorrection(double omegaRN) {
        this.omegaRiskNeutralCorrection = omegaRN;
        this.init();
    }

    @Override
    public RandomStream getStream() {
        return this.levyProcess.getStream();
    }

    @Override
    public void setStream(RandomStream stream) {
        this.levyProcess.setStream(stream);
    }
}

