/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import umontreal.ssj.stat.StatProbe;
import umontreal.ssj.stat.list.ArrayOfObservationListener;

public class ListOfStatProbes<E extends StatProbe>
implements Cloneable,
List<E>,
RandomAccess {
    private List<E> probes;
    private List<ArrayOfObservationListener> listeners = new ArrayList<ArrayOfObservationListener>();
    protected boolean collect = true;
    protected boolean broadcast = false;
    protected String name;

    public ListOfStatProbes() {
        this.probes = new ArrayList();
    }

    public ListOfStatProbes(String name) {
        this.probes = new ArrayList();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isModifiable() {
        return this.probes instanceof ArrayList;
    }

    public void setUnmodifiable() {
        if (this.isModifiable()) {
            this.probes = Collections.unmodifiableList(this.probes);
        }
    }

    public void init() {
        for (StatProbe probe : this.probes) {
            if (probe == null) continue;
            probe.init();
        }
    }

    public void sum(double[] s) {
        if (s.length != this.size()) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + s.length + ", required length is " + this.size());
        }
        int i = 0;
        for (StatProbe probe : this.probes) {
            s[i++] = probe == null ? Double.NaN : probe.sum();
        }
    }

    public void average(double[] a) {
        if (a.length != this.size()) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + a.length + ", required length is " + this.size());
        }
        int i = 0;
        for (StatProbe probe : this.probes) {
            a[i++] = probe == null ? Double.NaN : probe.average();
        }
    }

    public boolean isCollecting() {
        return this.collect;
    }

    public void setCollecting(boolean c) {
        this.collect = c;
    }

    public boolean isBroadcasting() {
        return this.broadcast;
    }

    public void setBroadcasting(boolean b) {
        this.broadcast = b;
    }

    public void addArrayOfObservationListener(ArrayOfObservationListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeArrayOfObservationListener(ArrayOfObservationListener l) {
        this.listeners.remove(l);
    }

    public void clearArrayOfObservationListeners() {
        this.listeners.clear();
    }

    public void notifyListeners(double[] x) {
        if (!this.broadcast) {
            return;
        }
        int nl = this.listeners.size();
        for (int i = 0; i < nl; ++i) {
            this.listeners.get(i).newArrayOfObservations(this, x);
        }
    }

    public String report() {
        return StatProbe.report(this.name, this);
    }

    public ListOfStatProbes<E> clone() {
        ListOfStatProbes sa;
        try {
            sa = (ListOfStatProbes)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("CloneNotSupportedException for a class implementing Cloneable");
        }
        if (this.probes != null) {
            sa.probes = new ArrayList<E>(this.probes);
        }
        return sa;
    }

    @Override
    public boolean add(E o) {
        return this.probes.add(o);
    }

    @Override
    public void add(int index, E o) {
        this.probes.add(index, o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.probes.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.probes.addAll(index, c);
    }

    @Override
    public void clear() {
        this.probes.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.probes.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.probes.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.probes.equals(o);
    }

    @Override
    public E get(int index) {
        return (E)((StatProbe)this.probes.get(index));
    }

    @Override
    public int hashCode() {
        return this.probes.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.probes.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.probes.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.probes.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.probes.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.probes.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.probes.listIterator();
    }

    @Override
    public E remove(int index) {
        return (E)((StatProbe)this.probes.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        return this.probes.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.probes.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.probes.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return (E)((StatProbe)this.probes.set(index, element));
    }

    @Override
    public int size() {
        return this.probes.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.probes.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.probes.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.probes.toArray(a);
    }
}

