/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import umontreal.ssj.randvar.ChiSquareNoncentralGamGen;
import umontreal.ssj.randvar.ChiSquareNoncentralGen;
import umontreal.ssj.randvar.ChiSquareNoncentralPoisGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.StochasticProcess;

public class CIRProcess
extends StochasticProcess {
    private RandomStream stream;
    protected ChiSquareNoncentralGen gen;
    protected double alpha;
    protected double beta;
    protected double sigma;
    protected double nu;
    protected double[] parc;
    protected double[] parlam;

    public CIRProcess(double x0, double alpha, double b, double sigma, RandomStream stream) {
        this(x0, alpha, b, sigma, new ChiSquareNoncentralGen(stream, null));
    }

    public CIRProcess(double x0, double alpha, double b, double sigma, ChiSquareNoncentralGen gen) {
        this.alpha = alpha;
        this.beta = b;
        this.sigma = sigma;
        this.x0 = x0;
        this.nu = 4.0 * b * alpha / (sigma * sigma);
        this.gen = gen;
        this.stream = gen.getStream();
    }

    @Override
    public double nextObservation() {
        double xOld = this.path[this.observationIndex];
        double lambda = xOld * this.parlam[this.observationIndex];
        double x = this.gen.getClass() == ChiSquareNoncentralPoisGen.class ? this.parc[this.observationIndex] * ChiSquareNoncentralPoisGen.nextDouble(this.stream, this.nu, lambda) : (this.gen.getClass() == ChiSquareNoncentralGamGen.class ? this.parc[this.observationIndex] * ChiSquareNoncentralGamGen.nextDouble(this.stream, this.nu, lambda) : this.parc[this.observationIndex] * ChiSquareNoncentralGen.nextDouble(this.stream, this.nu, lambda));
        ++this.observationIndex;
        this.path[this.observationIndex] = x;
        return x;
    }

    public double nextObservation(double nextTime) {
        double x;
        double previousTime = this.t[this.observationIndex];
        double xOld = this.path[this.observationIndex];
        ++this.observationIndex;
        this.t[this.observationIndex] = nextTime;
        double dt = nextTime - previousTime;
        this.path[this.observationIndex] = x = this.nextObservation(xOld, dt);
        return x;
    }

    public double nextObservation(double x, double dt) {
        double c = -Math.expm1(-this.alpha * dt) * this.sigma * this.sigma / (4.0 * this.alpha);
        double lambda = x * Math.exp(-this.alpha * dt) / c;
        x = this.gen.getClass() == ChiSquareNoncentralPoisGen.class ? c * ChiSquareNoncentralPoisGen.nextDouble(this.stream, this.nu, lambda) : (this.gen.getClass() == ChiSquareNoncentralGamGen.class ? c * ChiSquareNoncentralGamGen.nextDouble(this.stream, this.nu, lambda) : c * ChiSquareNoncentralGen.nextDouble(this.stream, this.nu, lambda));
        return x;
    }

    @Override
    public double[] generatePath() {
        double xOld = this.x0;
        if (this.gen.getClass() == ChiSquareNoncentralPoisGen.class) {
            for (int j = 0; j < this.d; ++j) {
                double x;
                double lambda = xOld * this.parlam[j];
                this.path[j + 1] = x = this.parc[j] * ChiSquareNoncentralPoisGen.nextDouble(this.stream, this.nu, lambda);
                xOld = x;
            }
        } else if (this.gen.getClass() == ChiSquareNoncentralGamGen.class) {
            for (int j = 0; j < this.d; ++j) {
                double x;
                double lambda = xOld * this.parlam[j];
                this.path[j + 1] = x = this.parc[j] * ChiSquareNoncentralGamGen.nextDouble(this.stream, this.nu, lambda);
                xOld = x;
            }
        } else {
            for (int j = 0; j < this.d; ++j) {
                double x;
                double lambda = xOld * this.parlam[j];
                this.path[j + 1] = x = this.parc[j] * ChiSquareNoncentralGen.nextDouble(this.stream, this.nu, lambda);
                xOld = x;
            }
        }
        this.observationIndex = this.d;
        return this.path;
    }

    @Override
    public double[] generatePath(RandomStream stream) {
        this.gen.setStream(stream);
        return this.generatePath();
    }

    public void setParams(double x0, double alpha, double b, double sigma) {
        this.alpha = alpha;
        this.beta = b;
        this.sigma = sigma;
        this.x0 = x0;
        this.nu = 4.0 * b * alpha / (sigma * sigma);
        if (this.observationTimesSet) {
            this.init();
        }
    }

    @Override
    public void setStream(RandomStream stream) {
        this.gen.setStream(stream);
    }

    @Override
    public RandomStream getStream() {
        return this.gen.getStream();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getB() {
        return this.beta;
    }

    public double getSigma() {
        return this.sigma;
    }

    public ChiSquareNoncentralGen getGen() {
        return this.gen;
    }

    protected void initArrays(int d) {
        for (int j = 0; j < d; ++j) {
            double c;
            double dt = this.t[j + 1] - this.t[j];
            this.parc[j] = c = -Math.expm1(-this.alpha * dt) * this.sigma * this.sigma / (4.0 * this.alpha);
            this.parlam[j] = Math.exp(-this.alpha * dt) / c;
        }
    }

    @Override
    protected void init() {
        super.init();
        this.parc = new double[this.d];
        this.parlam = new double[this.d];
        this.initArrays(this.d);
    }
}

