/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.LogarithmicDist;
import umontreal.ssj.randvar.RandomVariateGenInt;
import umontreal.ssj.rng.RandomStream;

public class LogarithmicGen
extends RandomVariateGenInt {
    private static final double default_theta_limit = 0.96;
    private double theta_limit = 0.96;
    private double theta;
    private double t;
    private double h;

    public LogarithmicGen(RandomStream s, double theta) {
        this(s, theta, 0.96);
    }

    public LogarithmicGen(RandomStream s, double theta, double theta0) {
        super(s, null);
        this.theta = theta;
        this.theta_limit = theta0;
        this.init();
    }

    public LogarithmicGen(RandomStream s, LogarithmicDist dist) {
        this(s, dist, 0.96);
    }

    public LogarithmicGen(RandomStream s, LogarithmicDist dist, double theta0) {
        super(s, dist);
        this.theta_limit = theta0;
        if (dist != null) {
            this.theta = dist.getTheta();
        }
        this.init();
    }

    private void init() {
        if (this.theta <= 0.0 || this.theta >= 1.0) {
            throw new IllegalArgumentException("theta not in (0, 1)");
        }
        if (this.theta >= this.theta_limit) {
            this.h = Math.log1p(-this.theta);
        } else {
            this.t = -this.theta / Math.log1p(-this.theta);
        }
    }

    @Override
    public int nextInt() {
        if (this.theta < this.theta_limit) {
            return LogarithmicGen.ls(this.stream, this.theta, this.t);
        }
        return LogarithmicGen.lk(this.stream, this.theta, this.h);
    }

    public static int nextInt(RandomStream s, double theta) {
        if (theta < 0.96) {
            return LogarithmicGen.ls(s, theta, -theta / Math.log1p(-theta));
        }
        return LogarithmicGen.lk(s, theta, Math.log1p(-theta));
    }

    private static int ls(RandomStream stream, double theta, double t) {
        double u = stream.nextDouble();
        int x = 1;
        for (double p = t; u > p; u -= p, p *= theta * ((double)(++x) - 1.0) / (double)x) {
        }
        return x;
    }

    private static int lk(RandomStream stream, double theta, double h) {
        double u = stream.nextDouble();
        if (u > theta) {
            return 1;
        }
        double v = stream.nextDouble();
        double q = 1.0 - Math.exp(v * h);
        if (u <= q * q) {
            int x = (int)(1.0 + Math.log(u) / Math.log(q));
            return x;
        }
        return u > q ? 1 : 2;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getTheta0() {
        return this.theta_limit;
    }
}

