/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(TestUtil.class);

    public static void clearAllStaticFieldsForUnitTest() {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            Class<?> theType;
            StackTraceElement[] st = e.getStackTrace();
            StackTraceElement elem = st[1];
            String clazzName = elem.getClassName();
            try {
                theType = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e1) {
                throw new Error(e);
            }
            for (Field next : Arrays.asList(theType.getDeclaredFields())) {
                if (!Modifier.isStatic(next.getModifiers())) continue;
                if (!Modifier.isFinal(next.getModifiers()) && !next.getType().isPrimitive()) {
                    ourLog.info("Clearing value of field: {}", (Object)next.toString());
                    try {
                        next.setAccessible(true);
                        next.set(theType, null);
                    }
                    catch (Exception e2) {
                        throw new Error(e2);
                    }
                }
                if (!Modifier.isFinal(next.getModifiers()) || !next.getType().equals(FhirContext.class)) continue;
                throw new Error("Test has final field of type FhirContext: " + next);
            }
            Locale[] availableLocales = new Locale[]{Locale.CANADA, Locale.GERMANY, Locale.TAIWAN};
            Locale.setDefault(availableLocales[(int)(Math.random() * (double)availableLocales.length)]);
            ourLog.info("Tests are running in locale: " + Locale.getDefault().getDisplayName());
            if (Math.random() < 0.5) {
                ourLog.info("Tests are using WINDOWS line endings and ISO-8851-1");
                System.setProperty("file.encoding", "ISO-8859-1");
                System.setProperty("line.separator", "\r\n");
            } else {
                ourLog.info("Tests are using UNIX line endings and UTF-8");
                System.setProperty("file.encoding", "UTF-8");
                System.setProperty("line.separator", "\n");
            }
            String[] availableTimeZones = new String[]{"GMT+08:00", "GMT-05:00", "GMT+00:00", "GMT+03:30"};
            String timeZone = availableTimeZones[(int)(Math.random() * (double)availableTimeZones.length)];
            TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
            ourLog.info("Tests are using time zone: {}", (Object)TimeZone.getDefault().getID());
            try {
                if ("true".equals(System.getProperty("ci"))) {
                    for (ch.qos.logback.classic.Logger next : ((LoggerContext)LoggerFactory.getILoggerFactory()).getLoggerList()) {
                        next.setLevel(Level.TRACE);
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return;
        }
    }
}

