/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.servlet;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRestfulResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequestDetails
extends RequestDetails {
    private static final Logger ourLog = LoggerFactory.getLogger(ServletRequestDetails.class);
    private static volatile BaseMethodBinding.IRequestReader ourRequestReader;
    private RestfulServer myServer;
    private HttpServletRequest myServletRequest;
    private HttpServletResponse myServletResponse;
    private byte[] requestContents;

    public ServletRequestDetails() {
        this.setResponse(new ServletRestfulResponse(this));
    }

    @Override
    protected byte[] getByteStreamRequestContents() {
        BaseMethodBinding.IRequestReader reader = ourRequestReader;
        if (reader == null) {
            try {
                Class.forName("javax.servlet.ServletInputStream");
                String className = BaseMethodBinding.class.getName() + "$" + "ActiveRequestReader";
                try {
                    reader = (BaseMethodBinding.IRequestReader)Class.forName(className).newInstance();
                }
                catch (Exception e1) {
                    throw new ConfigurationException("Failed to instantiate class " + className, e1);
                }
            }
            catch (ClassNotFoundException e) {
                String className = BaseMethodBinding.class.getName() + "$" + "InactiveRequestReader";
                try {
                    reader = (BaseMethodBinding.IRequestReader)Class.forName(className).newInstance();
                }
                catch (Exception e1) {
                    throw new ConfigurationException("Failed to instantiate class " + className, e1);
                }
            }
            ourRequestReader = reader;
        }
        try {
            String contentEncoding;
            InputStream inputStream = reader.getInputStream(this);
            this.requestContents = IOUtils.toByteArray((InputStream)inputStream);
            if (this.myServer.isUncompressIncomingContents() && "gzip".equals(contentEncoding = this.myServletRequest.getHeader("Content-Encoding"))) {
                ourLog.debug("Uncompressing (GZip) incoming content");
                if (this.requestContents.length > 0) {
                    GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(this.requestContents));
                    this.requestContents = IOUtils.toByteArray((InputStream)gis);
                }
            }
            return this.requestContents;
        }
        catch (IOException e) {
            ourLog.error("Could not load request resource", (Throwable)e);
            throw new InvalidRequestException(String.format("Could not load request resource: %s", e.getMessage()));
        }
    }

    @Override
    public String getHeader(String name) {
        return this.getServletRequest().getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        Enumeration headers = this.getServletRequest().getHeaders(name);
        return headers == null ? Collections.emptyList() : Collections.list(this.getServletRequest().getHeaders(name));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getServletRequest().getInputStream();
    }

    @Override
    public Reader getReader() throws IOException {
        return this.getServletRequest().getReader();
    }

    @Override
    public RestfulServer getServer() {
        return this.myServer;
    }

    @Override
    public String getServerBaseForRequest() {
        return this.getServer().getServerBaseForRequest(this.getServletRequest());
    }

    public HttpServletRequest getServletRequest() {
        return this.myServletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.myServletResponse;
    }

    public void setServer(RestfulServer theServer) {
        this.myServer = theServer;
    }

    public void setServletRequest(HttpServletRequest myServletRequest) {
        this.myServletRequest = myServletRequest;
    }

    public void setServletResponse(HttpServletResponse myServletResponse) {
        this.myServletResponse = myServletResponse;
    }

    public static RequestDetails withResourceAndParams(String theResourceName, RequestTypeEnum theRequestType, Set<String> theParamNames) {
        ServletRequestDetails retVal = new ServletRequestDetails();
        retVal.setResourceName(theResourceName);
        retVal.setRequestType(theRequestType);
        HashMap<String, String[]> paramNames = new HashMap<String, String[]>();
        for (String next : theParamNames) {
            paramNames.put(next, new String[0]);
        }
        retVal.setParameters(paramNames);
        return retVal;
    }

    @Override
    public Charset getCharset() {
        String ct = this.getHeader("Content-Type");
        Charset charset = null;
        if (StringUtils.isNotBlank((CharSequence)ct)) {
            ContentType parsedCt = ContentType.parse((String)ct);
            charset = parsedCt.getCharset();
        }
        return charset;
    }
}

