/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IServerInterceptor {
    public boolean handleException(RequestDetails var1, BaseServerResponseException var2, HttpServletRequest var3, HttpServletResponse var4) throws ServletException, IOException;

    public boolean incomingRequestPostProcessed(RequestDetails var1, HttpServletRequest var2, HttpServletResponse var3) throws AuthenticationException;

    public void incomingRequestPreHandled(RestOperationTypeEnum var1, ActionRequestDetails var2);

    public boolean incomingRequestPreProcessed(HttpServletRequest var1, HttpServletResponse var2);

    public boolean outgoingResponse(RequestDetails var1);

    public boolean outgoingResponse(RequestDetails var1, Bundle var2);

    public boolean outgoingResponse(RequestDetails var1, Bundle var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    public boolean outgoingResponse(RequestDetails var1, HttpServletRequest var2, HttpServletResponse var3) throws AuthenticationException;

    public boolean outgoingResponse(RequestDetails var1, IBaseResource var2);

    public boolean outgoingResponse(RequestDetails var1, IBaseResource var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    public boolean outgoingResponse(RequestDetails var1, TagList var2);

    public boolean outgoingResponse(RequestDetails var1, TagList var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    public BaseServerResponseException preProcessOutgoingException(RequestDetails var1, Throwable var2, HttpServletRequest var3) throws ServletException;

    public void processingCompletedNormally(ServletRequestDetails var1);

    public static class ActionRequestDetails {
        private final FhirContext myContext;
        private final IIdType myId;
        private RequestDetails myRequestDetails;
        private IBaseResource myResource;
        private final String myResourceType;

        public ActionRequestDetails(RequestDetails theRequestDetails) {
            this.myId = theRequestDetails.getId();
            this.myResourceType = theRequestDetails.getResourceName();
            this.myContext = theRequestDetails.getServer().getFhirContext();
            this.myRequestDetails = theRequestDetails;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, FhirContext theContext, IBaseResource theResource) {
            this(theRequestDetails, theContext, theContext.getResourceDefinition(theResource).getName(), theResource.getIdElement());
            this.myResource = theResource;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, FhirContext theContext, String theResourceType, IIdType theId) {
            this.myId = theId;
            this.myResourceType = theResourceType;
            this.myContext = theContext;
            this.myRequestDetails = theRequestDetails;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, IBaseResource theResource) {
            this(theRequestDetails, theRequestDetails.getServer().getFhirContext().getResourceDefinition(theResource).getName(), theResource.getIdElement());
            this.myResource = theResource;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, IBaseResource theResource, String theResourceType, IIdType theId) {
            this(theRequestDetails, theResourceType, theId);
            this.myResource = theResource;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, IIdType theId) {
            this(theRequestDetails, theId.getResourceType(), theId);
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, String theResourceType, IIdType theId) {
            this(theRequestDetails, theRequestDetails.getServer().getFhirContext(), theResourceType, theId);
        }

        public FhirContext getContext() {
            return this.myContext;
        }

        public IIdType getId() {
            return this.myId;
        }

        public RequestDetails getRequestDetails() {
            return this.myRequestDetails;
        }

        public IBaseResource getResource() {
            return this.myResource;
        }

        public String getResourceType() {
            return this.myResourceType;
        }

        public Map<Object, Object> getUserData() {
            return this.myRequestDetails.getUserData();
        }

        public void notifyIncomingRequestPreHandled(RestOperationTypeEnum theOperationType) {
            RequestDetails requestDetails = this.getRequestDetails();
            if (requestDetails == null) {
                return;
            }
            IRestfulServerDefaults server = requestDetails.getServer();
            if (server == null) {
                return;
            }
            List<IServerInterceptor> interceptors = server.getInterceptors();
            for (IServerInterceptor next : interceptors) {
                next.incomingRequestPreHandled(theOperationType, this);
            }
        }

        public void setResource(IBaseResource theObject) {
            this.myResource = theObject;
        }
    }
}

