/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.IRestfulResponse;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlingInterceptor
extends InterceptorAdapter {
    public static final String PROCESSING = "processing";
    private static final Logger ourLog = LoggerFactory.getLogger(ExceptionHandlingInterceptor.class);
    private Class<?>[] myReturnStackTracesForExceptionTypes;

    @Override
    public boolean handleException(RequestDetails theRequestDetails, BaseServerResponseException theException, HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException, IOException {
        Closeable writer = (Closeable)this.handleException(theRequestDetails, theException);
        writer.close();
        return false;
    }

    public Object handleException(RequestDetails theRequestDetails, BaseServerResponseException theException) throws ServletException, IOException {
        String sm;
        IRestfulResponse response = theRequestDetails.getResponse();
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        IBaseOperationOutcome oo = theException.getOperationOutcome();
        if (oo == null) {
            oo = this.createOperationOutcome(theException, ctx);
        }
        int statusCode = theException.getStatusCode();
        if (theException.hasResponseHeaders()) {
            Map<String, List<String>> additional = theException.getResponseHeaders();
            for (Map.Entry<String, List<String>> next : additional.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)next.getKey()) || next.getValue() == null) continue;
                String nextKey = next.getKey();
                for (String nextValue : next.getValue()) {
                    response.addHeader(nextKey, nextValue);
                }
            }
        }
        String statusMessage = null;
        if (theException instanceof UnclassifiedServerFailureException && StringUtils.isNotBlank((CharSequence)(sm = theException.getMessage())) && sm.indexOf(10) == -1) {
            statusMessage = sm;
        }
        return response.streamResponseAsResource(oo, true, Collections.singleton(SummaryEnum.FALSE), statusCode, statusMessage, false, false);
    }

    @Override
    public BaseServerResponseException preProcessOutgoingException(RequestDetails theRequestDetails, Throwable theException, HttpServletRequest theServletRequest) throws ServletException {
        BaseServerResponseException retVal = !(theException instanceof BaseServerResponseException) ? new InternalErrorException(theException) : (BaseServerResponseException)theException;
        if (retVal.getOperationOutcome() == null) {
            retVal.setOperationOutcome(this.createOperationOutcome(theException, theRequestDetails.getServer().getFhirContext()));
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBaseOperationOutcome createOperationOutcome(Throwable theException, FhirContext ctx) throws ServletException {
        IBaseOperationOutcome oo = null;
        if (theException instanceof BaseServerResponseException) {
            oo = ((BaseServerResponseException)theException).getOperationOutcome();
        }
        if (oo == null) {
            try {
                oo = OperationOutcomeUtil.newInstance(ctx);
                if (theException instanceof InternalErrorException) {
                    ourLog.error("Failure during REST processing", theException);
                    this.populateDetails(ctx, theException, oo);
                    return oo;
                }
                if (theException instanceof BaseServerResponseException) {
                    int statusCode = ((BaseServerResponseException)theException).getStatusCode();
                    if (statusCode < 500) {
                        ourLog.warn("Failure during REST processing: {}", (Object)theException.toString());
                    } else {
                        ourLog.warn("Failure during REST processing: {}", theException);
                    }
                    BaseServerResponseException baseServerResponseException = (BaseServerResponseException)theException;
                    this.populateDetails(ctx, theException, oo);
                    if (baseServerResponseException.getAdditionalMessages() == null) return oo;
                    for (String next : baseServerResponseException.getAdditionalMessages()) {
                        OperationOutcomeUtil.addIssue(ctx, oo, "error", next, null, PROCESSING);
                    }
                    return oo;
                }
                ourLog.error("Failure during REST processing: " + theException.toString(), theException);
                this.populateDetails(ctx, theException, oo);
                return oo;
            }
            catch (Exception e1) {
                ourLog.error("Failed to instantiate OperationOutcome resource instance", (Throwable)e1);
                throw new ServletException("Failed to instantiate OperationOutcome resource instance", (Throwable)e1);
            }
        } else {
            ourLog.error("Unknown error during processing", theException);
        }
        return oo;
    }

    private void populateDetails(FhirContext theCtx, Throwable theException, IBaseOperationOutcome theOo) {
        if (this.myReturnStackTracesForExceptionTypes != null) {
            for (Class<?> next : this.myReturnStackTracesForExceptionTypes) {
                if (!next.isAssignableFrom(theException.getClass())) continue;
                String detailsValue = theException.getMessage() + "\n\n" + ExceptionUtils.getStackTrace((Throwable)theException);
                OperationOutcomeUtil.addIssue(theCtx, theOo, "error", detailsValue, null, PROCESSING);
                return;
            }
        }
        OperationOutcomeUtil.addIssue(theCtx, theOo, "error", theException.getMessage(), null, PROCESSING);
    }

    public ExceptionHandlingInterceptor setReturnStackTracesForExceptionTypes(Class<?> ... theExceptionTypes) {
        this.myReturnStackTracesForExceptionTypes = theExceptionTypes;
        return this;
    }
}

