/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.method.ElementsParameter;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.method.SummaryEnumParameter;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IRestfulResponse;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.DateUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServerUtils {
    static final Pattern ACCEPT_HEADER_PATTERN = Pattern.compile("\\s*([a-zA-Z0-9+.*/-]+)\\s*(;\\s*([a-zA-Z]+)\\s*=\\s*([a-zA-Z0-9.]+)\\s*)?(,?)");
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServerUtils.class);
    private static final HashSet<String> TEXT_ENCODE_ELEMENTS = new HashSet<String>(Arrays.asList("Bundle", "*.text", "*.(mandatory)"));

    public static void configureResponseParser(RequestDetails theRequestDetails, IParser parser) {
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theRequestDetails.getServer(), theRequestDetails);
        parser.setPrettyPrint(prettyPrint);
        parser.setServerBaseUrl(theRequestDetails.getFhirServerBase());
        Set<SummaryEnum> summaryMode = RestfulServerUtils.determineSummaryMode(theRequestDetails);
        Set<String> elements = ElementsParameter.getElementsValueOrNull(theRequestDetails);
        if (elements != null && summaryMode != null && !summaryMode.equals(Collections.singleton(SummaryEnum.FALSE))) {
            throw new InvalidRequestException("Cannot combine the _summary and _elements parameters");
        }
        Set<String> elementsAppliesTo = null;
        if (elements != null && StringUtils.isNotBlank((CharSequence)theRequestDetails.getResourceName())) {
            elementsAppliesTo = Collections.singleton(theRequestDetails.getResourceName());
        }
        if (summaryMode != null) {
            if (summaryMode.contains((Object)SummaryEnum.COUNT)) {
                parser.setEncodeElements(Collections.singleton("Bundle.total"));
            } else if (summaryMode.contains((Object)SummaryEnum.TEXT)) {
                parser.setEncodeElements(TEXT_ENCODE_ELEMENTS);
            } else {
                parser.setSuppressNarratives(summaryMode.contains((Object)SummaryEnum.DATA));
                parser.setSummaryMode(summaryMode.contains((Object)SummaryEnum.TRUE));
            }
        }
        if (elements != null && elements.size() > 0) {
            HashSet<String> newElements = new HashSet<String>();
            for (String next : elements) {
                newElements.add("*." + next);
            }
            parser.setEncodeElements(newElements);
            parser.setEncodeElementsAppliesToResourceTypes(elementsAppliesTo);
        }
    }

    public static String createPagingLink(Set<Include> theIncludes, String theServerBase, String theSearchId, int theOffset, int theCount, EncodingEnum theResponseEncoding, boolean thePrettyPrint, BundleTypeEnum theBundleType) {
        try {
            StringBuilder b = new StringBuilder();
            b.append(theServerBase);
            b.append('?');
            b.append("_getpages");
            b.append('=');
            b.append(URLEncoder.encode(theSearchId, "UTF-8"));
            b.append('&');
            b.append("_getpagesoffset");
            b.append('=');
            b.append(theOffset);
            b.append('&');
            b.append("_count");
            b.append('=');
            b.append(theCount);
            if (theResponseEncoding != null) {
                b.append('&');
                b.append("_format");
                b.append('=');
                b.append(theResponseEncoding.getRequestContentType());
            }
            if (thePrettyPrint) {
                b.append('&');
                b.append("_pretty");
                b.append('=');
                b.append("true");
            }
            if (theIncludes != null) {
                for (Include nextInclude : theIncludes) {
                    if (!StringUtils.isNotBlank((CharSequence)nextInclude.getValue())) continue;
                    b.append('&');
                    b.append("_include");
                    b.append('=');
                    b.append(URLEncoder.encode(nextInclude.getValue(), "UTF-8"));
                }
            }
            if (theBundleType != null) {
                b.append('&');
                b.append(Constants.PARAM_BUNDLETYPE);
                b.append('=');
                b.append(theBundleType.getCode());
            }
            return b.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 not supported", e);
        }
    }

    public static EncodingEnum determineRequestEncoding(RequestDetails theReq) {
        EncodingEnum retVal = RestfulServerUtils.determineRequestEncodingNoDefault(theReq);
        if (retVal != null) {
            return retVal;
        }
        return EncodingEnum.XML;
    }

    public static EncodingEnum determineRequestEncodingNoDefault(RequestDetails theReq) {
        ResponseEncoding retVal = RestfulServerUtils.determineRequestEncodingNoDefaultReturnRE(theReq);
        if (retVal == null) {
            return null;
        }
        return retVal.getEncoding();
    }

    private static ResponseEncoding determineRequestEncodingNoDefaultReturnRE(RequestDetails theReq) {
        Iterator<String> acceptValues;
        ResponseEncoding retVal = null;
        List<String> headers = theReq.getHeaders("Content-Type");
        if (headers != null && (acceptValues = headers.iterator()) != null) {
            block0: while (acceptValues.hasNext() && retVal == null) {
                String nextAcceptHeaderValue = acceptValues.next();
                if (nextAcceptHeaderValue == null || !StringUtils.isNotBlank((CharSequence)nextAcceptHeaderValue)) continue;
                for (String nextPart : nextAcceptHeaderValue.split(",")) {
                    EncodingEnum encoding;
                    int scIdx = nextPart.indexOf(59);
                    if (scIdx == 0) continue;
                    if (scIdx != -1) {
                        nextPart = nextPart.substring(0, scIdx);
                    }
                    if ((encoding = EncodingEnum.forContentType(nextPart = nextPart.trim())) == null) continue;
                    retVal = new ResponseEncoding(theReq.getServer().getFhirContext(), encoding, nextPart);
                    continue block0;
                }
            }
        }
        return retVal;
    }

    public static ResponseEncoding determineResponseEncodingNoDefault(RequestDetails theReq, EncodingEnum thePrefer) {
        String[] format = theReq.getParameters().get("_format");
        if (format != null) {
            for (String nextFormat : format) {
                EncodingEnum retVal = EncodingEnum.forContentType(nextFormat);
                if (retVal == null) continue;
                return new ResponseEncoding(theReq.getServer().getFhirContext(), retVal, nextFormat);
            }
        }
        boolean strict = false;
        if ("Binary".equals(theReq.getResourceName())) {
            strict = true;
        }
        List<String> acceptValues = theReq.getHeaders("Accept");
        float bestQ = -1.0f;
        ResponseEncoding retVal = null;
        if (acceptValues != null) {
            for (String nextAcceptHeaderValue : acceptValues) {
                StringTokenizer tok = new StringTokenizer(nextAcceptHeaderValue, ",");
                while (tok.hasMoreTokens()) {
                    ResponseEncoding encoding;
                    String nextToken = tok.nextToken();
                    int startSpaceIndex = -1;
                    for (int i = 0; i < nextToken.length(); ++i) {
                        if (nextToken.charAt(i) == ' ') continue;
                        startSpaceIndex = i;
                        break;
                    }
                    if (startSpaceIndex == -1) continue;
                    int endSpaceIndex = -1;
                    for (int i = startSpaceIndex; i < nextToken.length(); ++i) {
                        if (nextToken.charAt(i) != ' ' && nextToken.charAt(i) != ';') continue;
                        endSpaceIndex = i;
                        break;
                    }
                    float q = 1.0f;
                    if (endSpaceIndex == -1) {
                        encoding = startSpaceIndex == 0 ? RestfulServerUtils.getEncodingForContentType(theReq.getServer().getFhirContext(), strict, nextToken) : RestfulServerUtils.getEncodingForContentType(theReq.getServer().getFhirContext(), strict, nextToken.substring(startSpaceIndex));
                    } else {
                        encoding = RestfulServerUtils.getEncodingForContentType(theReq.getServer().getFhirContext(), strict, nextToken.substring(startSpaceIndex, endSpaceIndex));
                        String remaining = nextToken.substring(endSpaceIndex + 1);
                        StringTokenizer qualifierTok = new StringTokenizer(remaining, ";");
                        while (qualifierTok.hasMoreTokens()) {
                            String nextQualifier = qualifierTok.nextToken();
                            int equalsIndex = nextQualifier.indexOf(61);
                            if (equalsIndex == -1) continue;
                            String nextQualifierKey = nextQualifier.substring(0, equalsIndex).trim();
                            String nextQualifierValue = nextQualifier.substring(equalsIndex + 1, nextQualifier.length()).trim();
                            if (!nextQualifierKey.equals("q")) continue;
                            try {
                                q = Float.parseFloat(nextQualifierValue);
                                q = Math.max(q, 0.0f);
                            }
                            catch (NumberFormatException e) {
                                ourLog.debug("Invalid Accept header q value: {}", (Object)nextQualifierValue);
                            }
                        }
                    }
                    if (encoding == null || !(q > bestQ) && (q != bestQ || encoding.getEncoding() != thePrefer)) continue;
                    retVal = encoding;
                    bestQ = q;
                }
            }
        }
        if (retVal == null) {
            retVal = RestfulServerUtils.determineRequestEncodingNoDefaultReturnRE(theReq);
        }
        return retVal;
    }

    public static ResponseEncoding determineResponseEncodingWithDefault(RequestDetails theReq) {
        ResponseEncoding retVal = RestfulServerUtils.determineResponseEncodingNoDefault(theReq, theReq.getServer().getDefaultResponseEncoding());
        if (retVal == null) {
            retVal = new ResponseEncoding(theReq.getServer().getFhirContext(), theReq.getServer().getDefaultResponseEncoding(), null);
        }
        return retVal;
    }

    public static Set<SummaryEnum> determineSummaryMode(RequestDetails theRequest) {
        String[] narrative;
        Map<String, String[]> requestParams = theRequest.getParameters();
        Set<SummaryEnum> retVal = SummaryEnumParameter.getSummaryValueOrNull(theRequest);
        if (retVal == null && (narrative = requestParams.get("_narrative")) != null && narrative.length > 0) {
            try {
                NarrativeModeEnum narrativeMode = NarrativeModeEnum.valueOfCaseInsensitive(narrative[0]);
                switch (narrativeMode) {
                    case NORMAL: {
                        retVal = Collections.singleton(SummaryEnum.FALSE);
                        break;
                    }
                    case ONLY: {
                        retVal = Collections.singleton(SummaryEnum.TEXT);
                        break;
                    }
                    case SUPPRESS: {
                        retVal = Collections.singleton(SummaryEnum.DATA);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ourLog.debug("Invalid {} parameger: {}", (Object)"_narrative", (Object)narrative[0]);
            }
        }
        if (retVal == null) {
            retVal = Collections.singleton(SummaryEnum.FALSE);
        }
        return retVal;
    }

    public static Integer extractCountParameter(RequestDetails theRequest) {
        return RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_count");
    }

    public static IPrimitiveType<Date> extractLastUpdatedFromResource(IBaseResource theResource) {
        IPrimitiveType lastUpdated = null;
        if (theResource instanceof IResource) {
            lastUpdated = ResourceMetadataKeyEnum.UPDATED.get((IResource)theResource);
        } else if (theResource instanceof IAnyResource) {
            lastUpdated = new InstantDt(((IAnyResource)theResource).getMeta().getLastUpdated());
        }
        return lastUpdated;
    }

    public static IIdType fullyQualifyResourceIdOrReturnNull(IRestfulServerDefaults theServer, IBaseResource theResource, String theServerBase, IIdType theResourceId) {
        IIdType retVal = null;
        if (theResourceId.hasIdPart() && StringUtils.isNotBlank((CharSequence)theServerBase)) {
            String resName = theResourceId.getResourceType();
            if (theResource != null && StringUtils.isBlank((CharSequence)resName)) {
                resName = theServer.getFhirContext().getResourceDefinition(theResource).getName();
            }
            if (StringUtils.isNotBlank((CharSequence)resName)) {
                retVal = theResourceId.withServerBase(theServerBase, resName);
            }
        }
        return retVal;
    }

    private static ResponseEncoding getEncodingForContentType(FhirContext theFhirContext, boolean theStrict, String theContentType) {
        EncodingEnum encoding = theStrict ? EncodingEnum.forContentTypeStrict(theContentType) : EncodingEnum.forContentType(theContentType);
        if (encoding == null) {
            return null;
        }
        return new ResponseEncoding(theFhirContext, encoding, theContentType);
    }

    public static IParser getNewParser(FhirContext theContext, RequestDetails theRequestDetails) {
        IParser parser;
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingWithDefault(theRequestDetails).getEncoding();
        switch (responseEncoding) {
            case JSON: {
                parser = theContext.newJsonParser();
                break;
            }
            default: {
                parser = theContext.newXmlParser();
            }
        }
        RestfulServerUtils.configureResponseParser(theRequestDetails, parser);
        return parser;
    }

    public static Set<String> parseAcceptHeaderAndReturnHighestRankedOptions(HttpServletRequest theRequest) {
        HashSet<String> retVal = new HashSet<String>();
        Enumeration acceptValues = theRequest.getHeaders("Accept");
        if (acceptValues != null) {
            float bestQ = -1.0f;
            block2: while (acceptValues.hasMoreElements()) {
                String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                Matcher m = ACCEPT_HEADER_PATTERN.matcher(nextAcceptHeaderValue);
                float q = 1.0f;
                while (m.find()) {
                    String contentTypeGroup = m.group(1);
                    if (StringUtils.isNotBlank((CharSequence)contentTypeGroup)) {
                        String name = m.group(3);
                        String value = m.group(4);
                        if (name != null && value != null && "q".equals(name)) {
                            try {
                                q = Float.parseFloat(value);
                                q = Math.max(q, 0.0f);
                            }
                            catch (NumberFormatException e) {
                                ourLog.debug("Invalid Accept header q value: {}", (Object)value);
                            }
                        }
                        if (q > bestQ) {
                            retVal.clear();
                            bestQ = q;
                        }
                        if (q == bestQ) {
                            retVal.add(contentTypeGroup.trim());
                        }
                    }
                    if (",".equals(m.group(5))) continue;
                    continue block2;
                }
            }
        }
        return retVal;
    }

    public static PreferReturnEnum parsePreferHeader(String theValue) {
        if (StringUtils.isBlank((CharSequence)theValue)) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(theValue, ",");
        while (tok.hasMoreTokens()) {
            String value;
            String key;
            String next = tok.nextToken();
            int eqIndex = next.indexOf(61);
            if (eqIndex == -1 || eqIndex >= next.length() - 2 || !(key = next.substring(0, eqIndex).trim()).equals("return") || (value = next.substring(eqIndex + 1).trim()).length() < 2) continue;
            if ('\"' == value.charAt(0) && '\"' == value.charAt(value.length() - 1)) {
                value = value.substring(1, value.length() - 1);
            }
            return PreferReturnEnum.fromHeaderValue(value);
        }
        return null;
    }

    public static boolean prettyPrintResponse(IRestfulServerDefaults theServer, RequestDetails theRequest) {
        boolean prettyPrint;
        Map<String, String[]> requestParams = theRequest.getParameters();
        String[] pretty = requestParams.get("_pretty");
        if (pretty != null && pretty.length > 0) {
            prettyPrint = "true".equals(pretty[0]);
        } else {
            prettyPrint = theServer.isDefaultPrettyPrint();
            List<String> acceptValues = theRequest.getHeaders("Accept");
            if (acceptValues != null) {
                for (String nextAcceptHeaderValue : acceptValues) {
                    if (!nextAcceptHeaderValue.contains("pretty=true")) continue;
                    prettyPrint = true;
                }
            }
        }
        return prettyPrint;
    }

    public static Object streamResponseAsBundle(IRestfulServerDefaults theServer, Bundle bundle, Set<SummaryEnum> theSummaryMode, boolean respondGzip, RequestDetails theRequestDetails) throws IOException {
        int status = 200;
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingWithDefault(theRequestDetails).getEncoding();
        String contentType = responseEncoding.getBundleContentType();
        String charset = "UTF-8";
        Writer writer = theRequestDetails.getResponse().getResponseWriter(status, null, contentType, charset, respondGzip);
        try {
            IParser parser = RestfulServerUtils.getNewParser(theServer.getFhirContext(), theRequestDetails);
            if (theSummaryMode.contains((Object)SummaryEnum.TEXT)) {
                parser.setEncodeElements(TEXT_ENCODE_ELEMENTS);
            }
            parser.encodeBundleToWriter(bundle, writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theRequestDetails.getResponse().sendWriterResponse(status, contentType, charset, writer);
    }

    public static Object streamResponseAsResource(IRestfulServerDefaults theServer, IBaseResource theResource, Set<SummaryEnum> theSummaryMode, int stausCode, boolean theAddContentLocationHeader, boolean respondGzip, RequestDetails theRequestDetails) throws IOException {
        return RestfulServerUtils.streamResponseAsResource(theServer, theResource, theSummaryMode, stausCode, null, theAddContentLocationHeader, respondGzip, theRequestDetails, null, null);
    }

    public static Object streamResponseAsResource(IRestfulServerDefaults theServer, IBaseResource theResource, Set<SummaryEnum> theSummaryMode, int theStausCode, String theStatusMessage, boolean theAddContentLocationHeader, boolean respondGzip, RequestDetails theRequestDetails, IIdType theOperationResourceId, IPrimitiveType<Date> theOperationResourceLastUpdated) throws IOException {
        TagList list;
        IPrimitiveType<Date> lastUpdated;
        boolean encodingDomainResourceAsText;
        String contentType;
        IRestfulResponse restUtil = theRequestDetails.getResponse();
        ResponseEncoding responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequestDetails, theServer.getDefaultResponseEncoding());
        String serverBase = theRequestDetails.getFhirServerBase();
        IIdType fullId = null;
        if (theOperationResourceId != null) {
            fullId = theOperationResourceId;
        } else if (theResource != null && theResource.getIdElement() != null) {
            IIdType resourceId = theResource.getIdElement();
            fullId = RestfulServerUtils.fullyQualifyResourceIdOrReturnNull(theServer, theResource, serverBase, resourceId);
        }
        if (theAddContentLocationHeader && fullId != null) {
            if (theServer.getFhirContext().getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                restUtil.addHeader("Content-Location", fullId.getValue());
            }
            restUtil.addHeader("Location", fullId.getValue());
        }
        if (theServer.getETagSupport() == ETagSupportEnum.ENABLED && fullId != null && fullId.hasVersionIdPart()) {
            restUtil.addHeader("ETag", "W/\"" + fullId.getVersionIdPart() + '\"');
        }
        if (theResource instanceof IBaseBinary && responseEncoding == null) {
            IBaseBinary bin = (IBaseBinary)theResource;
            contentType = StringUtils.isNotBlank((CharSequence)bin.getContentType()) ? bin.getContentType() : "application/octet-stream";
            restUtil.addHeader("Content-Disposition", "Attachment;");
            return restUtil.sendAttachmentResponse(bin, theStausCode, contentType);
        }
        if (responseEncoding == null) {
            responseEncoding = new ResponseEncoding(theServer.getFhirContext(), theServer.getDefaultResponseEncoding(), null);
        }
        if ((encodingDomainResourceAsText = theSummaryMode.contains((Object)SummaryEnum.TEXT)) && "Bundle".equals(theServer.getFhirContext().getResourceDefinition(theResource).getName())) {
            encodingDomainResourceAsText = false;
        }
        if ((lastUpdated = theOperationResourceLastUpdated != null ? theOperationResourceLastUpdated : RestfulServerUtils.extractLastUpdatedFromResource(theResource)) != null && !lastUpdated.isEmpty()) {
            restUtil.addHeader("Last-Modified", DateUtils.formatDate(lastUpdated.getValue()));
        }
        if (theResource instanceof IResource && theServer.getFhirContext().getVersion().getVersion() == FhirVersionEnum.DSTU1 && (list = (TagList)((IResource)theResource).getResourceMetadata().get(ResourceMetadataKeyEnum.TAG_LIST)) != null) {
            for (Tag tag : list) {
                if (!StringUtils.isNotBlank((CharSequence)tag.getTerm())) continue;
                restUtil.addHeader("Category", tag.toHeaderValue());
            }
        }
        contentType = theResource == null ? null : (encodingDomainResourceAsText ? "text/html" : responseEncoding.getResourceContentType());
        String charset = "UTF-8";
        Writer writer = restUtil.getResponseWriter(theStausCode, theStatusMessage, contentType, charset, respondGzip);
        if (theResource != null) {
            if (encodingDomainResourceAsText && theResource instanceof IResource) {
                writer.append(((IResource)theResource).getText().getDiv().getValueAsString());
            } else {
                IParser parser = RestfulServerUtils.getNewParser(theServer.getFhirContext(), theRequestDetails);
                parser.encodeResourceToWriter(theResource, writer);
            }
        }
        return restUtil.sendWriterResponse(theStausCode, contentType, charset, writer);
    }

    public static Integer tryToExtractNamedParameter(RequestDetails theRequest, String theParamName) {
        String[] retVal = theRequest.getParameters().get(theParamName);
        if (retVal == null) {
            return null;
        }
        try {
            return Integer.parseInt(retVal[0]);
        }
        catch (NumberFormatException e) {
            ourLog.debug("Failed to parse {} value '{}': {}", new Object[]{theParamName, retVal[0], e});
            return null;
        }
    }

    public static void validateResourceListNotNull(List<? extends IBaseResource> theResourceList) {
        if (theResourceList == null) {
            throw new InternalErrorException("IBundleProvider returned a null list of resources - This is not allowed");
        }
    }

    public static void addAcceptHeaderToRequest(EncodingEnum theEncoding, IHttpRequest theHttpRequest, FhirContext theContext) {
        if (theEncoding == null) {
            if (!theContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2)) {
                theHttpRequest.addHeader("Accept", "application/xml+fhir;q=1.0, application/json+fhir;q=1.0");
            } else {
                theHttpRequest.addHeader("Accept", Constants.HEADER_ACCEPT_VALUE_XML_OR_JSON_NON_LEGACY);
            }
        } else if (theEncoding == EncodingEnum.JSON) {
            if (!theContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2)) {
                theHttpRequest.addHeader("Accept", "application/json+fhir");
            } else {
                theHttpRequest.addHeader("Accept", "application/fhir+json;q=1.0, application/json+fhir;q=0.9");
            }
        } else if (theEncoding == EncodingEnum.XML) {
            if (!theContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2)) {
                theHttpRequest.addHeader("Accept", "application/xml+fhir");
            } else {
                theHttpRequest.addHeader("Accept", "application/fhir+xml;q=1.0, application/xml+fhir;q=0.9");
            }
        }
    }

    public static class ResponseEncoding {
        private final EncodingEnum myEncoding;
        private final Boolean myNonLegacy;

        public ResponseEncoding(FhirContext theCtx, EncodingEnum theEncoding, String theContentType) {
            this.myEncoding = theEncoding;
            this.myNonLegacy = theContentType != null ? (theContentType.equals("json") || theContentType.equals("xml") ? Boolean.valueOf(!theCtx.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) : Boolean.valueOf(EncodingEnum.isNonLegacy(theContentType))) : (theCtx.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3) ? null : Boolean.TRUE);
        }

        public EncodingEnum getEncoding() {
            return this.myEncoding;
        }

        public String getResourceContentType() {
            if (Boolean.TRUE.equals(this.isNonLegacy())) {
                return this.getEncoding().getResourceContentTypeNonLegacy();
            }
            return this.getEncoding().getResourceContentType();
        }

        public Boolean isNonLegacy() {
            return this.myNonLegacy;
        }
    }

    private static enum NarrativeModeEnum {
        NORMAL,
        ONLY,
        SUPPRESS;


        public static NarrativeModeEnum valueOfCaseInsensitive(String theCode) {
            return NarrativeModeEnum.valueOf(NarrativeModeEnum.class, theCode.toUpperCase());
        }
    }
}

