/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class StringParam
extends BaseParam
implements IQueryParameterType {
    private boolean myExact;
    private String myValue;
    private boolean myContains;

    public StringParam() {
    }

    public StringParam(String theValue) {
        this.setValue(theValue);
    }

    public StringParam(String theValue, boolean theExact) {
        this.setValue(theValue);
        this.setExact(theExact);
    }

    @Override
    String doGetQueryParameterQualifier() {
        if (this.isExact()) {
            return ":exact";
        }
        if (this.isContains()) {
            return ":contains";
        }
        return null;
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        return ParameterUtil.escape(this.myValue);
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        if (":exact".equals(theQualifier)) {
            this.setExact(true);
        } else {
            this.setExact(false);
        }
        if (":contains".equals(theQualifier)) {
            this.setContains(true);
        } else {
            this.setContains(false);
        }
        this.myValue = ParameterUtil.unescape(theValue);
    }

    public String getValue() {
        return this.myValue;
    }

    public StringDt getValueAsStringDt() {
        return new StringDt(this.myValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString((String)this.myValue);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.myValue);
    }

    public boolean isExact() {
        return this.myExact;
    }

    public StringParam setExact(boolean theExact) {
        this.myExact = theExact;
        if (this.myExact) {
            this.setContains(false);
            this.setMissing(null);
        }
        return this;
    }

    public boolean isContains() {
        return this.myContains;
    }

    public StringParam setValue(String theValue) {
        this.myValue = theValue;
        return this;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("value", (Object)this.getValue());
        if (this.myExact) {
            builder.append("exact", this.myExact);
        }
        if (this.myContains) {
            builder.append("contains", this.myContains);
        }
        if (this.getMissing() != null) {
            builder.append("missing", this.getMissing().booleanValue());
        }
        return builder.toString();
    }

    public StringParam setContains(boolean theContains) {
        this.myContains = theContains;
        if (this.myContains) {
            this.setExact(false);
            this.setMissing(null);
        }
        return this;
    }
}

