/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.util.CoverageIgnore;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ReferenceParam
extends BaseParam
implements IQueryParameterType {
    private String myChain;
    private final IdDt myId = new IdDt();

    public ReferenceParam() {
    }

    public ReferenceParam(String theValue) {
        this.setValueAsQueryToken(null, null, null, theValue);
    }

    public ReferenceParam(String theChain, String theValue) {
        this.setValueAsQueryToken(null, null, null, theValue);
        this.setChain(theChain);
    }

    public ReferenceParam(String theResourceType, String theChain, String theValue) {
        if (StringUtils.isNotBlank((CharSequence)theResourceType)) {
            this.setValue(theResourceType + "/" + theValue);
        } else {
            this.setValue(theValue);
        }
        this.setChain(theChain);
    }

    @Override
    String doGetQueryParameterQualifier() {
        StringBuilder b = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getResourceType())) {
            b.append(':');
            b.append(this.getResourceType());
        }
        if (StringUtils.isNotBlank((CharSequence)this.myChain)) {
            b.append('.');
            b.append(this.myChain);
        }
        if (b.length() != 0) {
            return b.toString();
        }
        return null;
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        if (StringUtils.isBlank((CharSequence)this.myId.getResourceType())) {
            return this.myId.getValue();
        }
        return this.myId.getIdPart();
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        String q = theQualifier;
        String resourceType = null;
        if (StringUtils.isNotBlank((CharSequence)q)) {
            if (q.startsWith(":")) {
                int nextIdx = q.indexOf(46);
                if (nextIdx != -1) {
                    resourceType = q.substring(1, nextIdx);
                    this.myChain = q.substring(nextIdx + 1);
                } else {
                    resourceType = q.substring(1);
                }
            } else if (q.startsWith(".")) {
                this.myChain = q.substring(1);
            }
        }
        this.setValue(theValue);
        if (StringUtils.isNotBlank(resourceType) && StringUtils.isBlank((CharSequence)this.getResourceType())) {
            this.setValue(resourceType + '/' + theValue);
        }
    }

    @CoverageIgnore
    public String getBaseUrl() {
        return this.myId.getBaseUrl();
    }

    public String getChain() {
        return this.myChain;
    }

    @CoverageIgnore
    public String getIdPart() {
        return this.myId.getIdPart();
    }

    @CoverageIgnore
    public BigDecimal getIdPartAsBigDecimal() {
        return this.myId.getIdPartAsBigDecimal();
    }

    @CoverageIgnore
    public Long getIdPartAsLong() {
        return this.myId.getIdPartAsLong();
    }

    public String getResourceType() {
        return this.myId.getResourceType();
    }

    public Class<? extends IBaseResource> getResourceType(FhirContext theCtx) {
        if (StringUtils.isBlank((CharSequence)this.getResourceType())) {
            return null;
        }
        return theCtx.getResourceDefinition(this.getResourceType()).getImplementingClass();
    }

    public String getValue() {
        return this.myId.getValue();
    }

    public boolean hasResourceType() {
        return this.myId.hasResourceType();
    }

    @Override
    protected boolean isSupportsChain() {
        return true;
    }

    public void setChain(String theChain) {
        this.myChain = theChain;
    }

    public void setValue(String theValue) {
        this.myId.setValue(theValue);
    }

    public DateParam toDateParam(FhirContext theContext) {
        DateParam retVal = new DateParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public NumberParam toNumberParam(FhirContext theContext) {
        NumberParam retVal = new NumberParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public QuantityParam toQuantityParam(FhirContext theContext) {
        QuantityParam retVal = new QuantityParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (StringUtils.isNotBlank((CharSequence)this.myChain)) {
            b.append("chain", (Object)this.myChain);
        }
        b.append("value", (Object)this.getValue());
        return b.build();
    }

    public StringParam toStringParam(FhirContext theContext) {
        StringParam retVal = new StringParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }

    public TokenParam toTokenParam(FhirContext theContext) {
        TokenParam retVal = new TokenParam();
        retVal.setValueAsQueryToken(theContext, null, null, this.getValueAsQueryToken(theContext));
        return retVal;
    }
}

