/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.method.QualifiedParamList;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class DateRangeParam
implements IQueryParameterAnd<DateParam> {
    private DateParam myLowerBound;
    private DateParam myUpperBound;

    public DateRangeParam() {
    }

    public DateRangeParam(Date theLowerBound, Date theUpperBound) {
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    public DateRangeParam(DateParam theDateParam) {
        if (theDateParam == null) {
            throw new NullPointerException("theDateParam can not be null");
        }
        if (theDateParam.isEmpty()) {
            throw new IllegalArgumentException("theDateParam can not be empty");
        }
        if (theDateParam.getPrefix() == null) {
            this.setRangeFromDatesInclusive(theDateParam.getValueAsString(), theDateParam.getValueAsString());
        } else {
            switch (theDateParam.getPrefix()) {
                case EQUAL: {
                    this.setRangeFromDatesInclusive(theDateParam.getValueAsString(), theDateParam.getValueAsString());
                    break;
                }
                case STARTS_AFTER: 
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    this.myLowerBound = theDateParam;
                    this.myUpperBound = null;
                    break;
                }
                case ENDS_BEFORE: 
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    this.myLowerBound = null;
                    this.myUpperBound = theDateParam;
                    break;
                }
                default: {
                    throw new InvalidRequestException("Invalid comparator for date range parameter:" + (Object)((Object)theDateParam.getPrefix()) + ". This is a bug.");
                }
            }
        }
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public DateRangeParam(DateParam theLowerBound, DateParam theUpperBound) {
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    public DateRangeParam(IPrimitiveType<Date> theLowerBound, IPrimitiveType<Date> theUpperBound) {
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    public DateRangeParam(String theLowerBound, String theUpperBound) {
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    private void addParam(DateParam theParsed) throws InvalidRequestException {
        if (theParsed.getPrefix() == null || theParsed.getPrefix() == ParamPrefixEnum.EQUAL) {
            if (this.myLowerBound != null || this.myUpperBound != null) {
                throw new InvalidRequestException("Can not have multiple date range parameters for the same param without a qualifier");
            }
            this.myLowerBound = new DateParam(ParamPrefixEnum.EQUAL, theParsed.getValueAsString());
            this.myUpperBound = new DateParam(ParamPrefixEnum.EQUAL, theParsed.getValueAsString());
        } else {
            switch (theParsed.getPrefix()) {
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    if (this.myLowerBound != null) {
                        throw new InvalidRequestException("Can not have multiple date range parameters for the same param that specify a lower bound");
                    }
                    this.myLowerBound = theParsed;
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    if (this.myUpperBound != null) {
                        throw new InvalidRequestException("Can not have multiple date range parameters for the same param that specify an upper bound");
                    }
                    this.myUpperBound = theParsed;
                    break;
                }
                default: {
                    throw new InvalidRequestException("Unknown comparator: " + (Object)((Object)theParsed.getPrefix()));
                }
            }
        }
    }

    public DateParam getLowerBound() {
        return this.myLowerBound;
    }

    public Date getLowerBoundAsInstant() {
        if (this.myLowerBound == null) {
            return null;
        }
        Date retVal = this.myLowerBound.getValue();
        if (this.myLowerBound.getPrefix() != null) {
            switch (this.myLowerBound.getPrefix()) {
                case GREATERTHAN: {
                    retVal = this.myLowerBound.getPrecision().add(retVal, 1);
                    break;
                }
                case EQUAL: 
                case GREATERTHAN_OR_EQUALS: {
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    throw new IllegalStateException("Unvalid lower bound comparator: " + (Object)((Object)this.myLowerBound.getPrefix()));
                }
            }
        }
        return retVal;
    }

    public DateParam getUpperBound() {
        return this.myUpperBound;
    }

    public Date getUpperBoundAsInstant() {
        if (this.myUpperBound == null) {
            return null;
        }
        Date retVal = this.myUpperBound.getValue();
        if (this.myUpperBound.getPrefix() != null) {
            switch (this.myUpperBound.getPrefix()) {
                case LESSTHAN: {
                    retVal = new Date(retVal.getTime() - 1L);
                    break;
                }
                case EQUAL: 
                case LESSTHAN_OR_EQUALS: {
                    retVal = this.myUpperBound.getPrecision().add(retVal, 1);
                    retVal = new Date(retVal.getTime() - 1L);
                    break;
                }
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    throw new IllegalStateException("Unvalid upper bound comparator: " + (Object)((Object)this.myUpperBound.getPrefix()));
                }
            }
        }
        return retVal;
    }

    @Override
    public List<DateParam> getValuesAsQueryTokens() {
        ArrayList<DateParam> retVal = new ArrayList<DateParam>();
        if (this.myLowerBound != null && !this.myLowerBound.isEmpty()) {
            retVal.add(this.myLowerBound);
        }
        if (this.myUpperBound != null && !this.myUpperBound.isEmpty()) {
            retVal.add(this.myUpperBound);
        }
        return retVal;
    }

    private boolean haveLowerBound() {
        return this.myLowerBound != null && !this.myLowerBound.isEmpty();
    }

    private boolean haveUpperBound() {
        return this.myUpperBound != null && !this.myUpperBound.isEmpty();
    }

    public boolean isEmpty() {
        return this.getLowerBoundAsInstant() == null && this.getUpperBoundAsInstant() == null;
    }

    public void setLowerBound(DateParam theLowerBound) {
        this.myLowerBound = theLowerBound;
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public void setRangeFromDatesInclusive(Date theLowerBound, Date theUpperBound) {
        this.myLowerBound = theLowerBound != null ? new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theLowerBound) : null;
        this.myUpperBound = theUpperBound != null ? new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, theUpperBound) : null;
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public void setRangeFromDatesInclusive(DateParam theLowerBound, DateParam theUpperBound) {
        this.myLowerBound = theLowerBound;
        this.myUpperBound = theUpperBound;
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public void setRangeFromDatesInclusive(IPrimitiveType<Date> theLowerBound, IPrimitiveType<Date> theUpperBound) {
        IPrimitiveType<Date> lowerBound = theLowerBound;
        IPrimitiveType<Date> upperBound = theUpperBound;
        if (lowerBound != null && lowerBound.getValue() != null && upperBound != null && upperBound.getValue() != null && lowerBound.getValue().after(upperBound.getValue())) {
            IPrimitiveType<Date> temp = lowerBound;
            lowerBound = upperBound;
            upperBound = temp;
        }
        this.myLowerBound = lowerBound != null ? new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, lowerBound) : null;
        this.myUpperBound = upperBound != null ? new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, upperBound) : null;
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public void setRangeFromDatesInclusive(String theLowerBound, String theUpperBound) {
        this.myLowerBound = theLowerBound != null ? new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theLowerBound) : null;
        DateParam dateParam = this.myUpperBound = theUpperBound != null ? new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, theUpperBound) : null;
        if (StringUtils.isNotBlank((CharSequence)theLowerBound) && StringUtils.isNotBlank((CharSequence)theUpperBound) && theLowerBound.equals(theUpperBound)) {
            this.myLowerBound.setPrefix(ParamPrefixEnum.EQUAL);
            this.myUpperBound.setPrefix(ParamPrefixEnum.EQUAL);
        }
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    public void setUpperBound(DateParam theUpperBound) {
        this.myUpperBound = theUpperBound;
        this.validateAndThrowDataFormatExceptionIfInvalid();
    }

    @Override
    public void setValuesAsQueryTokens(FhirContext theContext, String theParamName, List<QualifiedParamList> theParameters) throws InvalidRequestException {
        boolean haveHadUnqualifiedParameter = false;
        for (QualifiedParamList paramList : theParameters) {
            if (paramList.size() == 0) continue;
            if (paramList.size() > 1) {
                throw new InvalidRequestException("DateRange parameter does not suppport OR queries");
            }
            String param = (String)paramList.get(0);
            param = param.replace(' ', '+');
            DateParam parsed = new DateParam();
            parsed.setValueAsQueryToken(theContext, theParamName, paramList.getQualifier(), param);
            this.addParam(parsed);
            if (parsed.getPrefix() != null) continue;
            if (haveHadUnqualifiedParameter) {
                throw new InvalidRequestException("Multiple date parameters with the same name and no qualifier (>, <, etc.) is not supported");
            }
            haveHadUnqualifiedParameter = true;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        if (this.haveLowerBound()) {
            if (this.myLowerBound.getPrefix() != null) {
                b.append(this.myLowerBound.getPrefix().getValue());
            }
            b.append(this.myLowerBound.getValueAsString());
        }
        if (this.haveUpperBound()) {
            if (this.haveLowerBound()) {
                b.append(" ");
            }
            if (this.myUpperBound.getPrefix() != null) {
                b.append(this.myUpperBound.getPrefix().getValue());
            }
            b.append(this.myUpperBound.getValueAsString());
        } else if (!this.haveLowerBound()) {
            b.append("empty");
        }
        b.append("]");
        return b.toString();
    }

    private void validateAndThrowDataFormatExceptionIfInvalid() {
        boolean haveLowerBound = this.haveLowerBound();
        boolean haveUpperBound = this.haveUpperBound();
        if (haveLowerBound && haveUpperBound && this.myLowerBound.getValue().getTime() > this.myUpperBound.getValue().getTime()) {
            StringBuilder b = new StringBuilder();
            b.append("Lower bound of ");
            b.append(this.myLowerBound.getValueAsString());
            b.append(" is after upper bound of ");
            b.append(this.myUpperBound.getValueAsString());
            throw new DataFormatException(b.toString());
        }
        if (haveLowerBound) {
            if (this.myLowerBound.getPrefix() == null) {
                this.myLowerBound.setPrefix(ParamPrefixEnum.GREATERTHAN_OR_EQUALS);
            }
            switch (this.myLowerBound.getPrefix()) {
                default: {
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    throw new DataFormatException("Lower bound comparator must be > or >=, can not be " + this.myLowerBound.getPrefix().getValue());
                }
            }
        }
        if (haveUpperBound) {
            if (this.myUpperBound.getPrefix() == null) {
                this.myUpperBound.setPrefix(ParamPrefixEnum.LESSTHAN_OR_EQUALS);
            }
            switch (this.myUpperBound.getPrefix()) {
                default: {
                    break;
                }
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    throw new DataFormatException("Upper bound comparator must be < or <=, can not be " + this.myUpperBound.getPrefix().getValue());
                }
            }
        }
    }
}

