/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseOutcomeReturningMethodBindingWithResourceParam;
import ca.uhn.fhir.rest.method.HttpPutClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class UpdateMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceParam {
    private Integer myIdParameterIndex;

    public UpdateMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, Update.class, theProvider);
        this.myIdParameterIndex = MethodUtil.findIdParameterIndex(theMethod, this.getContext());
    }

    @Override
    protected void addParametersForServerRequest(RequestDetails theRequest, Object[] theParams) {
        String locationHeader = theRequest.getHeader("Content-Location");
        IIdType id = theRequest.getId();
        if (StringUtils.isNotBlank((CharSequence)locationHeader)) {
            id.setValue(locationHeader);
            if (StringUtils.isNotBlank((CharSequence)id.getResourceType()) && !this.getResourceName().equals(id.getResourceType())) {
                throw new InvalidRequestException("Attempting to update '" + this.getResourceName() + "' but content-location header specifies different resource type '" + id.getResourceType() + "' - header value: " + locationHeader);
            }
        }
        id = UpdateMethodBinding.applyETagAsVersion(theRequest, id);
        if (theRequest.getId() != null && !theRequest.getId().hasVersionIdPart() && id != null && id.hasVersionIdPart()) {
            theRequest.getId().setValue(id.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)locationHeader)) {
            MethodOutcome mo = new MethodOutcome();
            UpdateMethodBinding.parseContentLocation(this.getContext(), mo, locationHeader);
            if (mo.getId() == null || mo.getId().isEmpty()) {
                throw new InvalidRequestException("Invalid Content-Location header for resource " + this.getResourceName() + ": " + locationHeader);
            }
        }
        super.addParametersForServerRequest(theRequest, theParams);
    }

    public static IIdType applyETagAsVersion(RequestDetails theRequest, IIdType id) {
        String ifMatchValue = theRequest.getHeader("If-Match");
        if (StringUtils.isNotBlank((CharSequence)ifMatchValue)) {
            ifMatchValue = MethodUtil.parseETagValue(ifMatchValue);
            if (id != null && !id.hasVersionIdPart()) {
                id = id.withVersion(ifMatchValue);
            }
        }
        return id;
    }

    @Override
    protected BaseHttpClientInvocation createClientInvocation(Object[] theArgs, IResource theResource) {
        IdDt idDt = (IdDt)theArgs[this.myIdParameterIndex];
        if (idDt == null) {
            throw new NullPointerException("ID can not be null");
        }
        FhirContext context = this.getContext();
        HttpPutClientInvocation retVal = MethodUtil.createUpdateInvocation(theResource, null, idDt, context);
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.UPDATE;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.PUT);
    }

    @Override
    protected void validateResourceIdAndUrlIdForNonConditionalOperation(IBaseResource theResource, String theResourceId, String theUrlId, String theMatchUrl) {
        if (StringUtils.isBlank((CharSequence)theMatchUrl)) {
            if (StringUtils.isBlank((CharSequence)theUrlId)) {
                String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "noIdInUrlForUpdate", new Object[0]);
                throw new InvalidRequestException(msg);
            }
            if (this.getContext().getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                if (StringUtils.isBlank((CharSequence)theResourceId)) {
                    ourLog.warn("No resource ID found in resource body for update");
                    theResource.setId(theUrlId);
                } else if (!theResourceId.equals(theUrlId)) {
                    String msg = this.getContext().getLocalizer().getMessage(BaseOutcomeReturningMethodBindingWithResourceParam.class, "incorrectIdForUpdate", theResourceId, theUrlId);
                    throw new InvalidRequestException(msg);
                }
            }
        } else {
            theResource.setId((IIdType)null);
        }
    }
}

