/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.param.ResourceParameter;
import ca.uhn.fhir.rest.param.TransactionParameter;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IRestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionMethodBinding
extends BaseResourceReturningMethodBinding {
    private int myTransactionParamIndex = -1;
    private TransactionParameter.ParamStyle myTransactionParamStyle;

    public TransactionMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(null, theMethod, theContext, theProvider);
        int index = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof TransactionParameter) {
                if (this.myTransactionParamIndex != -1) {
                    throw new ConfigurationException("Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " has multiple parameters annotated with the @" + TransactionParam.class + " annotation, exactly one is required for @" + Transaction.class + " methods");
                }
                this.myTransactionParamIndex = index;
                this.myTransactionParamStyle = ((TransactionParameter)next).getParamStyle();
            }
            ++index;
        }
        if (this.myTransactionParamIndex == -1) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " does not have a parameter annotated with the @" + TransactionParam.class + " annotation");
        }
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.TRANSACTION;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.TRANSACTION_RESPONSE;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (theRequest.getRequestType() != RequestTypeEnum.POST) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)theRequest.getOperation())) {
            return false;
        }
        return !StringUtils.isNotBlank((CharSequence)theRequest.getResourceName());
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        FhirContext context = this.getContext();
        if (theArgs[this.myTransactionParamIndex] instanceof Bundle) {
            Bundle bundle = (Bundle)theArgs[this.myTransactionParamIndex];
            return TransactionMethodBinding.createTransactionInvocation(bundle, context);
        }
        List resources = (List)theArgs[this.myTransactionParamIndex];
        return TransactionMethodBinding.createTransactionInvocation(resources, context);
    }

    public Object invokeServer(IRestfulServer theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        if (this.myTransactionParamStyle == TransactionParameter.ParamStyle.RESOURCE_BUNDLE) {
            Object response = this.invokeServerMethod(theServer, theRequest, theMethodParams);
            return response;
        }
        List<IResource> resources = theMethodParams[this.myTransactionParamIndex] instanceof Bundle ? ((Bundle)theMethodParams[this.myTransactionParamIndex]).toListOfResources() : (List<IResource>)theMethodParams[this.myTransactionParamIndex];
        IdentityHashMap<IResource, IdDt> oldIds = new IdentityHashMap<IResource, IdDt>();
        for (IResource next : resources) {
            oldIds.put(next, next.getId());
        }
        Object response = this.invokeServerMethod(theServer, theRequest, theMethodParams);
        IBundleProvider retVal = this.toResourceList(response);
        List<IBaseResource> retResources = retVal.getResources(0, retVal.size());
        for (int i = 0; i < retResources.size(); ++i) {
            IdDt oldId = (IdDt)oldIds.get(retResources.get(i));
            IBaseResource newRes = retResources.get(i);
            if ((newRes.getIdElement() == null || newRes.getIdElement().isEmpty()) && !(newRes instanceof BaseOperationOutcome)) {
                throw new InternalErrorException("Transaction method returned resource at index " + i + " with no id specified - IResource#setId(IdDt)");
            }
            if (oldId == null || oldId.isEmpty() || oldId.equals(newRes.getIdElement()) || !(newRes instanceof IResource)) continue;
            ((IResource)newRes).getResourceMetadata().put(ResourceMetadataKeyEnum.PREVIOUS_ID, oldId);
        }
        return retVal;
    }

    @Override
    protected void populateActionRequestDetailsForInterceptor(RequestDetails theRequestDetails, IServerInterceptor.ActionRequestDetails theDetails, Object[] theMethodParams) {
        super.populateActionRequestDetailsForInterceptor(theRequestDetails, theDetails, theMethodParams);
        if (this.myTransactionParamIndex != -1) {
            theDetails.setResource((IBaseResource)theMethodParams[this.myTransactionParamIndex]);
        } else {
            Class resourceType = this.getContext().getResourceDefinition("Bundle").getImplementingClass();
            theDetails.setResource(ResourceParameter.parseResourceFromRequest(theRequestDetails, this, resourceType));
        }
    }

    public static BaseHttpClientInvocation createTransactionInvocation(Bundle theBundle, FhirContext theContext) {
        return new HttpPostClientInvocation(theContext, theBundle);
    }

    public static BaseHttpClientInvocation createTransactionInvocation(IBaseBundle theBundle, FhirContext theContext) {
        return new HttpPostClientInvocation(theContext, theBundle);
    }

    public static BaseHttpClientInvocation createTransactionInvocation(List<? extends IBaseResource> theResources, FhirContext theContext) {
        return new HttpPostClientInvocation(theContext, theResources, BundleTypeEnum.TRANSACTION);
    }

    public static BaseHttpClientInvocation createTransactionInvocation(String theRawBundle, FhirContext theContext) {
        return new HttpPostClientInvocation(theContext, theRawBundle, true, "");
    }
}

