/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.GetTags;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.ParseAction;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IRestfulServer;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class GetTagsMethodBinding
extends BaseMethodBinding<TagList> {
    private Integer myIdParamIndex;
    private String myResourceName;
    private Class<? extends IBaseResource> myType;
    private Integer myVersionIdParamIndex;

    public GetTagsMethodBinding(Method theMethod, FhirContext theContext, Object theProvider, GetTags theAnnotation) {
        super(theMethod, theContext, theProvider);
        this.myType = theProvider instanceof IResourceProvider ? ((IResourceProvider)theProvider).getResourceType() : theAnnotation.type();
        if (!Modifier.isInterface(this.myType.getModifiers())) {
            this.myResourceName = theContext.getResourceDefinition(this.myType).getName();
        }
        this.myIdParamIndex = MethodUtil.findIdParameterIndex(theMethod, this.getContext());
        this.myVersionIdParamIndex = MethodUtil.findVersionIdParameterIndex(theMethod);
        if (this.myIdParamIndex != null && this.myType.equals(IResource.class)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' does not specify a resource type, but has an @" + IdParam.class.getSimpleName() + " parameter. Please specity a resource type in the @" + GetTags.class.getSimpleName() + " annotation");
        }
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.GET_TAGS;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (theRequest.getRequestType() != RequestTypeEnum.GET) {
            return false;
        }
        if (!"_tags".equals(theRequest.getOperation())) {
            return false;
        }
        if (this.myResourceName == null ? this.getResourceName() != null : !this.myResourceName.equals(theRequest.getResourceName())) {
            return false;
        }
        return this.myIdParamIndex != null == (theRequest.getId() != null);
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        IdDt id = null;
        IdDt versionId = null;
        if (this.myIdParamIndex != null) {
            id = (IdDt)theArgs[this.myIdParamIndex];
            if (this.myVersionIdParamIndex != null) {
                versionId = (IdDt)theArgs[this.myVersionIdParamIndex];
            }
        }
        HttpGetClientInvocation retVal = this.myType != IResource.class ? (id != null ? (versionId != null ? new HttpGetClientInvocation(this.getContext(), this.getResourceName(), id.getIdPart(), "_history", versionId.getValue(), "_tags") : (id.hasVersionIdPart() ? new HttpGetClientInvocation(this.getContext(), this.getResourceName(), id.getIdPart(), "_history", id.getVersionIdPart(), "_tags") : new HttpGetClientInvocation(this.getContext(), this.getResourceName(), id.getIdPart(), "_tags"))) : new HttpGetClientInvocation(this.getContext(), this.getResourceName(), "_tags")) : new HttpGetClientInvocation(this.getContext(), "_tags");
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
            }
        }
        return retVal;
    }

    @Override
    public TagList invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
        if (theResponseStatusCode == 200) {
            IParser parser = this.createAppropriateParserForParsingResponse(theResponseMimeType, theResponseReader, theResponseStatusCode, null);
            TagList retVal = parser.parseTagList(theResponseReader);
            return retVal;
        }
        throw this.processNon2xxResponseAndReturnExceptionToThrow(theResponseStatusCode, theResponseMimeType, theResponseReader);
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        Object[] params = this.createParametersForServerRequest(theRequest);
        if (this.myIdParamIndex != null) {
            params[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        if (this.myVersionIdParamIndex != null) {
            params[this.myVersionIdParamIndex.intValue()] = theRequest.getId();
        }
        TagList resp = (TagList)this.invokeServerMethod(theServer, theRequest, params);
        for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
            IServerInterceptor next = theServer.getInterceptors().get(i);
            boolean continueProcessing = next.outgoingResponse(theRequest, resp);
            if (continueProcessing) continue;
            return null;
        }
        return theRequest.getResponse().returnResponse(ParseAction.create(resp), 200, false, null, null);
    }
}

