/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

abstract class BaseHttpClientInvocationWithContents
extends BaseHttpClientInvocation {
    private final Bundle myBundle;
    private final BundleTypeEnum myBundleType;
    private final String myContents;
    private boolean myContentsIsBundle;
    private Map<String, List<String>> myIfNoneExistParams;
    private String myIfNoneExistString;
    private boolean myOmitResourceId = false;
    private Map<String, List<String>> myParams;
    private final IBaseResource myResource;
    private final List<? extends IBaseResource> myResources;
    private final TagList myTagList;
    private final String myUrlPath;
    private IIdType myForceResourceId;

    public BaseHttpClientInvocationWithContents(FhirContext theContext, Bundle theBundle) {
        super(theContext);
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = null;
        this.myResources = null;
        this.myBundle = theBundle;
        this.myContents = null;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, IBaseResource theResource, Map<String, List<String>> theParams, String ... theUrlPath) {
        super(theContext);
        this.myResource = theResource;
        this.myTagList = null;
        this.myUrlPath = StringUtils.join((Object[])theUrlPath, (char)'/');
        this.myResources = null;
        this.myBundle = null;
        this.myContents = null;
        this.myContentsIsBundle = false;
        this.myParams = theParams;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, IBaseResource theResource, String theUrlPath) {
        super(theContext);
        this.myResource = theResource;
        this.myUrlPath = theUrlPath;
        this.myTagList = null;
        this.myResources = null;
        this.myBundle = null;
        this.myContents = null;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, List<? extends IBaseResource> theResources, BundleTypeEnum theBundleType) {
        super(theContext);
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = null;
        this.myResources = theResources;
        this.myBundle = null;
        this.myContents = null;
        this.myBundleType = theBundleType;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, Map<String, List<String>> theParams, String ... theUrlPath) {
        super(theContext);
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = StringUtils.join((Object[])theUrlPath, (char)'/');
        this.myResources = null;
        this.myBundle = null;
        this.myContents = null;
        this.myContentsIsBundle = false;
        this.myParams = theParams;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, String theContents, boolean theIsBundle, String theUrlPath) {
        super(theContext);
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = theUrlPath;
        this.myResources = null;
        this.myBundle = null;
        this.myContents = theContents;
        this.myContentsIsBundle = theIsBundle;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, String theContents, Map<String, List<String>> theParams, String ... theUrlPath) {
        super(theContext);
        this.myResource = null;
        this.myTagList = null;
        this.myUrlPath = StringUtils.join((Object[])theUrlPath, (char)'/');
        this.myResources = null;
        this.myBundle = null;
        this.myContents = theContents;
        this.myContentsIsBundle = false;
        this.myParams = theParams;
        this.myBundleType = null;
    }

    public BaseHttpClientInvocationWithContents(FhirContext theContext, TagList theTagList, String ... theUrlPath) {
        super(theContext);
        if (theTagList == null) {
            throw new NullPointerException("Tag list must not be null");
        }
        this.myResource = null;
        this.myTagList = theTagList;
        this.myResources = null;
        this.myBundle = null;
        this.myContents = null;
        this.myBundleType = null;
        this.myUrlPath = StringUtils.join((Object[])theUrlPath, (char)'/');
    }

    @Override
    public IHttpRequest asHttpRequest(String theUrlBase, Map<String, List<String>> theExtraParams, EncodingEnum theEncoding, Boolean thePrettyPrint) throws DataFormatException {
        IBaseBinary binary;
        StringBuilder url = new StringBuilder();
        if (this.myUrlPath == null) {
            url.append(theUrlBase);
        } else {
            if (!this.myUrlPath.contains("://")) {
                url.append(theUrlBase);
                if (!theUrlBase.endsWith("/")) {
                    url.append('/');
                }
            }
            url.append(this.myUrlPath);
        }
        BaseHttpClientInvocationWithContents.appendExtraParamsWithQuestionMark(theExtraParams, url, url.indexOf("?") == -1);
        IHttpClient httpClient = this.getRestfulClientFactory().getHttpClient(url, this.myIfNoneExistParams, this.myIfNoneExistString, this.getRequestType(), this.getHeaders());
        if (this.myResource != null && IBaseBinary.class.isAssignableFrom(this.myResource.getClass()) && StringUtils.isNotBlank((CharSequence)(binary = (IBaseBinary)this.myResource).getContentType()) && EncodingEnum.forContentTypeStrict(binary.getContentType()) == null) {
            return httpClient.createBinaryRequest(this.getContext(), binary);
        }
        EncodingEnum encoding = theEncoding;
        if (this.myContents != null) {
            encoding = MethodUtil.detectEncoding(this.myContents);
        }
        if (this.myParams != null) {
            return httpClient.createParamRequest(this.getContext(), this.myParams, encoding);
        }
        encoding = (EncodingEnum)((Object)ObjectUtils.defaultIfNull((Object)((Object)encoding), (Object)((Object)EncodingEnum.XML)));
        String contents = this.encodeContents(thePrettyPrint, encoding);
        String contentType = this.getContentType(encoding);
        return httpClient.createByteRequest(this.getContext(), contents, contentType, encoding);
    }

    private String getContentType(EncodingEnum encoding) {
        if (this.myBundle != null || this.getContext().getVersion().getVersion() == FhirVersionEnum.DSTU1 && (this.myContents != null && this.myContentsIsBundle || this.myResources != null)) {
            return encoding.getBundleContentType();
        }
        if (this.getContext().getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
            return encoding.getResourceContentType();
        }
        return encoding.getResourceContentTypeNonLegacy();
    }

    protected abstract RequestTypeEnum getRequestType();

    private String encodeContents(Boolean thePrettyPrint, EncodingEnum encoding) {
        IParser parser = encoding == EncodingEnum.JSON ? this.getContext().newJsonParser() : this.getContext().newXmlParser();
        if (thePrettyPrint != null) {
            parser.setPrettyPrint(thePrettyPrint);
        }
        if (this.myForceResourceId != null) {
            parser.setEncodeForceResourceId(this.myForceResourceId);
        }
        parser.setOmitResourceId(this.myOmitResourceId);
        if (this.myTagList != null) {
            return parser.encodeTagListToString(this.myTagList);
        }
        if (this.myBundle != null) {
            return parser.encodeBundleToString(this.myBundle);
        }
        if (this.myResources != null) {
            IVersionSpecificBundleFactory bundleFactory = this.getContext().newBundleFactory();
            bundleFactory.initializeBundleFromResourceList("", this.myResources, "", "", this.myResources.size(), this.myBundleType);
            Bundle bundle = bundleFactory.getDstu1Bundle();
            if (bundle != null) {
                return parser.encodeBundleToString(bundle);
            }
            IBaseResource bundleRes = bundleFactory.getResourceBundle();
            return parser.encodeResourceToString(bundleRes);
        }
        if (this.myContents != null) {
            return this.myContents;
        }
        return parser.encodeResourceToString(this.myResource);
    }

    public void setForceResourceId(IIdType theId) {
        this.myForceResourceId = theId;
    }

    public void setIfNoneExistParams(Map<String, List<String>> theIfNoneExist) {
        this.myIfNoneExistParams = theIfNoneExist;
    }

    public void setIfNoneExistString(String theIfNoneExistString) {
        this.myIfNoneExistString = theIfNoneExistString;
    }

    public void setOmitResourceId(boolean theOmitResourceId) {
        this.myOmitResourceId = theOmitResourceId;
    }
}

